<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_ServiceProduct StructType
 * @subpackage Structs
 */
class JP_ServiceProduct extends AbstractStructBase
{
    /**
     * The ServiceInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_ServiceInfo
     */
    public $ServiceInfo;
    /**
     * The ServiceOptions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_ServiceOption
     */
    public $ServiceOptions;
    /**
     * The ServiceBookingInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_ServiceBookingInfo
     */
    public $ServiceBookingInfo;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The ICode
     * @var string
     */
    public $ICode;
    /**
     * The SearchMore
     * @var bool
     */
    public $SearchMore;
    /**
     * The Order
     * @var int
     */
    public $Order;
    /**
     * Constructor method for JP_ServiceProduct
     * @uses JP_ServiceProduct::setServiceInfo()
     * @uses JP_ServiceProduct::setServiceOptions()
     * @uses JP_ServiceProduct::setServiceBookingInfo()
     * @uses JP_ServiceProduct::setCode()
     * @uses JP_ServiceProduct::setICode()
     * @uses JP_ServiceProduct::setSearchMore()
     * @uses JP_ServiceProduct::setOrder()
     * @param \StructType\JP_ServiceInfo $serviceInfo
     * @param \ArrayType\ArrayOfJP_ServiceOption $serviceOptions
     * @param \StructType\JP_ServiceBookingInfo $serviceBookingInfo
     * @param string $code
     * @param string $iCode
     * @param bool $searchMore
     * @param int $order
     */
    public function __construct(\StructType\JP_ServiceInfo $serviceInfo = null, \ArrayType\ArrayOfJP_ServiceOption $serviceOptions = null, \StructType\JP_ServiceBookingInfo $serviceBookingInfo = null, $code = null, $iCode = null, $searchMore = null, $order = null)
    {
        $this
            ->setServiceInfo($serviceInfo)
            ->setServiceOptions($serviceOptions)
            ->setServiceBookingInfo($serviceBookingInfo)
            ->setCode($code)
            ->setICode($iCode)
            ->setSearchMore($searchMore)
            ->setOrder($order);
    }
    /**
     * Get ServiceInfo value
     * @return \StructType\JP_ServiceInfo|null
     */
    public function getServiceInfo()
    {
        return $this->ServiceInfo;
    }
    /**
     * Set ServiceInfo value
     * @param \StructType\JP_ServiceInfo $serviceInfo
     * @return \StructType\JP_ServiceProduct
     */
    public function setServiceInfo(\StructType\JP_ServiceInfo $serviceInfo = null)
    {
        $this->ServiceInfo = $serviceInfo;
        return $this;
    }
    /**
     * Get ServiceOptions value
     * @return \ArrayType\ArrayOfJP_ServiceOption|null
     */
    public function getServiceOptions()
    {
        return $this->ServiceOptions;
    }
    /**
     * Set ServiceOptions value
     * @param \ArrayType\ArrayOfJP_ServiceOption $serviceOptions
     * @return \StructType\JP_ServiceProduct
     */
    public function setServiceOptions(\ArrayType\ArrayOfJP_ServiceOption $serviceOptions = null)
    {
        $this->ServiceOptions = $serviceOptions;
        return $this;
    }
    /**
     * Get ServiceBookingInfo value
     * @return \StructType\JP_ServiceBookingInfo|null
     */
    public function getServiceBookingInfo()
    {
        return $this->ServiceBookingInfo;
    }
    /**
     * Set ServiceBookingInfo value
     * @param \StructType\JP_ServiceBookingInfo $serviceBookingInfo
     * @return \StructType\JP_ServiceProduct
     */
    public function setServiceBookingInfo(\StructType\JP_ServiceBookingInfo $serviceBookingInfo = null)
    {
        $this->ServiceBookingInfo = $serviceBookingInfo;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_ServiceProduct
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get ICode value
     * @return string|null
     */
    public function getICode()
    {
        return $this->ICode;
    }
    /**
     * Set ICode value
     * @param string $iCode
     * @return \StructType\JP_ServiceProduct
     */
    public function setICode($iCode = null)
    {
        // validation for constraint: string
        if (!is_null($iCode) && !is_string($iCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iCode)), __LINE__);
        }
        $this->ICode = $iCode;
        return $this;
    }
    /**
     * Get SearchMore value
     * @return bool|null
     */
    public function getSearchMore()
    {
        return $this->SearchMore;
    }
    /**
     * Set SearchMore value
     * @param bool $searchMore
     * @return \StructType\JP_ServiceProduct
     */
    public function setSearchMore($searchMore = null)
    {
        // validation for constraint: boolean
        if (!is_null($searchMore) && !is_bool($searchMore)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($searchMore)), __LINE__);
        }
        $this->SearchMore = $searchMore;
        return $this;
    }
    /**
     * Get Order value
     * @return int|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param int $order
     * @return \StructType\JP_ServiceProduct
     */
    public function setOrder($order = null)
    {
        // validation for constraint: int
        if (!is_null($order) && !is_numeric($order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($order)), __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_ServiceProduct
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
