<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_Reservation StructType
 * @subpackage Structs
 */
class JP_Reservation extends AbstractStructBase
{
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Status;
    /**
     * The ExternalBookingReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExternalBookingReference;
    /**
     * The Holder
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Holder
     */
    public $Holder;
    /**
     * The Paxes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Paxes
     */
    public $Paxes;
    /**
     * The Comments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Comment
     */
    public $Comments;
    /**
     * The FinalCustomerCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $FinalCustomerCode;
    /**
     * The AgenciesData
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_AgencyData
     */
    public $AgenciesData;
    /**
     * The Items
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Items
     */
    public $Items;
    /**
     * The ReservationCode
     * @var int
     */
    public $ReservationCode;
    /**
     * The Locator
     * @var string
     */
    public $Locator;
    /**
     * The BookingChannel
     * @var string
     */
    public $BookingChannel;
    /**
     * The Language
     * @var string
     */
    public $Language;
    /**
     * Constructor method for JP_Reservation
     * @uses JP_Reservation::setStatus()
     * @uses JP_Reservation::setExternalBookingReference()
     * @uses JP_Reservation::setHolder()
     * @uses JP_Reservation::setPaxes()
     * @uses JP_Reservation::setComments()
     * @uses JP_Reservation::setFinalCustomerCode()
     * @uses JP_Reservation::setAgenciesData()
     * @uses JP_Reservation::setItems()
     * @uses JP_Reservation::setReservationCode()
     * @uses JP_Reservation::setLocator()
     * @uses JP_Reservation::setBookingChannel()
     * @uses JP_Reservation::setLanguage()
     * @param string $status
     * @param string $externalBookingReference
     * @param \StructType\JP_Holder $holder
     * @param \StructType\JP_Paxes $paxes
     * @param \ArrayType\ArrayOfJP_Comment $comments
     * @param int $finalCustomerCode
     * @param \ArrayType\ArrayOfJP_AgencyData $agenciesData
     * @param \StructType\JP_Items $items
     * @param int $reservationCode
     * @param string $locator
     * @param string $bookingChannel
     * @param string $language
     */
    public function __construct($status = null, $externalBookingReference = null, \StructType\JP_Holder $holder = null, \StructType\JP_Paxes $paxes = null, \ArrayType\ArrayOfJP_Comment $comments = null, $finalCustomerCode = null, \ArrayType\ArrayOfJP_AgencyData $agenciesData = null, \StructType\JP_Items $items = null, $reservationCode = null, $locator = null, $bookingChannel = null, $language = null)
    {
        $this
            ->setStatus($status)
            ->setExternalBookingReference($externalBookingReference)
            ->setHolder($holder)
            ->setPaxes($paxes)
            ->setComments($comments)
            ->setFinalCustomerCode($finalCustomerCode)
            ->setAgenciesData($agenciesData)
            ->setItems($items)
            ->setReservationCode($reservationCode)
            ->setLocator($locator)
            ->setBookingChannel($bookingChannel)
            ->setLanguage($language);
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\JP_ResStatus::valueIsValid()
     * @uses \EnumType\JP_ResStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\JP_Reservation
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_ResStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\JP_ResStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get ExternalBookingReference value
     * @return string|null
     */
    public function getExternalBookingReference()
    {
        return $this->ExternalBookingReference;
    }
    /**
     * Set ExternalBookingReference value
     * @param string $externalBookingReference
     * @return \StructType\JP_Reservation
     */
    public function setExternalBookingReference($externalBookingReference = null)
    {
        // validation for constraint: string
        if (!is_null($externalBookingReference) && !is_string($externalBookingReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalBookingReference)), __LINE__);
        }
        $this->ExternalBookingReference = $externalBookingReference;
        return $this;
    }
    /**
     * Get Holder value
     * @return \StructType\JP_Holder|null
     */
    public function getHolder()
    {
        return $this->Holder;
    }
    /**
     * Set Holder value
     * @param \StructType\JP_Holder $holder
     * @return \StructType\JP_Reservation
     */
    public function setHolder(\StructType\JP_Holder $holder = null)
    {
        $this->Holder = $holder;
        return $this;
    }
    /**
     * Get Paxes value
     * @return \StructType\JP_Paxes|null
     */
    public function getPaxes()
    {
        return $this->Paxes;
    }
    /**
     * Set Paxes value
     * @param \StructType\JP_Paxes $paxes
     * @return \StructType\JP_Reservation
     */
    public function setPaxes(\StructType\JP_Paxes $paxes = null)
    {
        $this->Paxes = $paxes;
        return $this;
    }
    /**
     * Get Comments value
     * @return \ArrayType\ArrayOfJP_Comment|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param \ArrayType\ArrayOfJP_Comment $comments
     * @return \StructType\JP_Reservation
     */
    public function setComments(\ArrayType\ArrayOfJP_Comment $comments = null)
    {
        $this->Comments = $comments;
        return $this;
    }
    /**
     * Get FinalCustomerCode value
     * @return int|null
     */
    public function getFinalCustomerCode()
    {
        return $this->FinalCustomerCode;
    }
    /**
     * Set FinalCustomerCode value
     * @param int $finalCustomerCode
     * @return \StructType\JP_Reservation
     */
    public function setFinalCustomerCode($finalCustomerCode = null)
    {
        // validation for constraint: int
        if (!is_null($finalCustomerCode) && !is_numeric($finalCustomerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($finalCustomerCode)), __LINE__);
        }
        $this->FinalCustomerCode = $finalCustomerCode;
        return $this;
    }
    /**
     * Get AgenciesData value
     * @return \ArrayType\ArrayOfJP_AgencyData|null
     */
    public function getAgenciesData()
    {
        return $this->AgenciesData;
    }
    /**
     * Set AgenciesData value
     * @param \ArrayType\ArrayOfJP_AgencyData $agenciesData
     * @return \StructType\JP_Reservation
     */
    public function setAgenciesData(\ArrayType\ArrayOfJP_AgencyData $agenciesData = null)
    {
        $this->AgenciesData = $agenciesData;
        return $this;
    }
    /**
     * Get Items value
     * @return \StructType\JP_Items|null
     */
    public function getItems()
    {
        return $this->Items;
    }
    /**
     * Set Items value
     * @param \StructType\JP_Items $items
     * @return \StructType\JP_Reservation
     */
    public function setItems(\StructType\JP_Items $items = null)
    {
        $this->Items = $items;
        return $this;
    }
    /**
     * Get ReservationCode value
     * @return int|null
     */
    public function getReservationCode()
    {
        return $this->ReservationCode;
    }
    /**
     * Set ReservationCode value
     * @param int $reservationCode
     * @return \StructType\JP_Reservation
     */
    public function setReservationCode($reservationCode = null)
    {
        // validation for constraint: int
        if (!is_null($reservationCode) && !is_numeric($reservationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($reservationCode)), __LINE__);
        }
        $this->ReservationCode = $reservationCode;
        return $this;
    }
    /**
     * Get Locator value
     * @return string|null
     */
    public function getLocator()
    {
        return $this->Locator;
    }
    /**
     * Set Locator value
     * @param string $locator
     * @return \StructType\JP_Reservation
     */
    public function setLocator($locator = null)
    {
        // validation for constraint: string
        if (!is_null($locator) && !is_string($locator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($locator)), __LINE__);
        }
        $this->Locator = $locator;
        return $this;
    }
    /**
     * Get BookingChannel value
     * @return string|null
     */
    public function getBookingChannel()
    {
        return $this->BookingChannel;
    }
    /**
     * Set BookingChannel value
     * @param string $bookingChannel
     * @return \StructType\JP_Reservation
     */
    public function setBookingChannel($bookingChannel = null)
    {
        // validation for constraint: string
        if (!is_null($bookingChannel) && !is_string($bookingChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bookingChannel)), __LINE__);
        }
        $this->BookingChannel = $bookingChannel;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\JP_Reservation
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_Reservation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
