<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_InsuranceCheckAvailResult StructType
 * @subpackage Structs
 */
class JP_InsuranceCheckAvailResult extends AbstractStructBase
{
    /**
     * The InsuranceInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_InsuranceInfo
     */
    public $InsuranceInfo;
    /**
     * The Prices
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Price
     */
    public $Prices;
    /**
     * The RatePlanCode
     * @var string
     */
    public $RatePlanCode;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * Constructor method for JP_InsuranceCheckAvailResult
     * @uses JP_InsuranceCheckAvailResult::setInsuranceInfo()
     * @uses JP_InsuranceCheckAvailResult::setPrices()
     * @uses JP_InsuranceCheckAvailResult::setRatePlanCode()
     * @uses JP_InsuranceCheckAvailResult::setStatus()
     * @param \StructType\JP_InsuranceInfo $insuranceInfo
     * @param \ArrayType\ArrayOfJP_Price $prices
     * @param string $ratePlanCode
     * @param string $status
     */
    public function __construct(\StructType\JP_InsuranceInfo $insuranceInfo = null, \ArrayType\ArrayOfJP_Price $prices = null, $ratePlanCode = null, $status = null)
    {
        $this
            ->setInsuranceInfo($insuranceInfo)
            ->setPrices($prices)
            ->setRatePlanCode($ratePlanCode)
            ->setStatus($status);
    }
    /**
     * Get InsuranceInfo value
     * @return \StructType\JP_InsuranceInfo|null
     */
    public function getInsuranceInfo()
    {
        return $this->InsuranceInfo;
    }
    /**
     * Set InsuranceInfo value
     * @param \StructType\JP_InsuranceInfo $insuranceInfo
     * @return \StructType\JP_InsuranceCheckAvailResult
     */
    public function setInsuranceInfo(\StructType\JP_InsuranceInfo $insuranceInfo = null)
    {
        $this->InsuranceInfo = $insuranceInfo;
        return $this;
    }
    /**
     * Get Prices value
     * @return \ArrayType\ArrayOfJP_Price|null
     */
    public function getPrices()
    {
        return $this->Prices;
    }
    /**
     * Set Prices value
     * @param \ArrayType\ArrayOfJP_Price $prices
     * @return \StructType\JP_InsuranceCheckAvailResult
     */
    public function setPrices(\ArrayType\ArrayOfJP_Price $prices = null)
    {
        $this->Prices = $prices;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \StructType\JP_InsuranceCheckAvailResult
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\JP_AvailStatus::valueIsValid()
     * @uses \EnumType\JP_AvailStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\JP_InsuranceCheckAvailResult
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_AvailStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\JP_AvailStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_InsuranceCheckAvailResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
