<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_FlightDiscount StructType
 * @subpackage Structs
 */
class JP_FlightDiscount extends AbstractStructBase
{
    /**
     * The Resident
     * @var bool
     */
    public $Resident;
    /**
     * The LargeFamily
     * @var string
     */
    public $LargeFamily;
    /**
     * Constructor method for JP_FlightDiscount
     * @uses JP_FlightDiscount::setResident()
     * @uses JP_FlightDiscount::setLargeFamily()
     * @param bool $resident
     * @param string $largeFamily
     */
    public function __construct($resident = null, $largeFamily = null)
    {
        $this
            ->setResident($resident)
            ->setLargeFamily($largeFamily);
    }
    /**
     * Get Resident value
     * @return bool|null
     */
    public function getResident()
    {
        return $this->Resident;
    }
    /**
     * Set Resident value
     * @param bool $resident
     * @return \StructType\JP_FlightDiscount
     */
    public function setResident($resident = null)
    {
        // validation for constraint: boolean
        if (!is_null($resident) && !is_bool($resident)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($resident)), __LINE__);
        }
        $this->Resident = $resident;
        return $this;
    }
    /**
     * Get LargeFamily value
     * @return string|null
     */
    public function getLargeFamily()
    {
        return $this->LargeFamily;
    }
    /**
     * Set LargeFamily value
     * @param string $largeFamily
     * @return \StructType\JP_FlightDiscount
     */
    public function setLargeFamily($largeFamily = null)
    {
        // validation for constraint: string
        if (!is_null($largeFamily) && !is_string($largeFamily)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($largeFamily)), __LINE__);
        }
        $this->LargeFamily = $largeFamily;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_FlightDiscount
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
