<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_CruiseCategory StructType
 * @subpackage Structs
 */
class JP_CruiseCategory extends AbstractStructBase
{
    /**
     * The Prices
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Price
     */
    public $Prices;
    /**
     * The AdditionalElements
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_CruiseAdditionalElements
     */
    public $AdditionalElements;
    /**
     * The Cabins
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_CruiseCabin
     */
    public $Cabins;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Description
     */
    public $Description;
    /**
     * The Images
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString1
     */
    public $Images;
    /**
     * The ImagesLong
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_ImageLong
     */
    public $ImagesLong;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The DeckLoc
     * @var string
     */
    public $DeckLoc;
    /**
     * The SelectionCode
     * @var string
     */
    public $SelectionCode;
    /**
     * The RatePlanCode
     * @var string
     */
    public $RatePlanCode;
    /**
     * Constructor method for JP_CruiseCategory
     * @uses JP_CruiseCategory::setPrices()
     * @uses JP_CruiseCategory::setAdditionalElements()
     * @uses JP_CruiseCategory::setCabins()
     * @uses JP_CruiseCategory::setName()
     * @uses JP_CruiseCategory::setDescription()
     * @uses JP_CruiseCategory::setImages()
     * @uses JP_CruiseCategory::setImagesLong()
     * @uses JP_CruiseCategory::setCode()
     * @uses JP_CruiseCategory::setDeckLoc()
     * @uses JP_CruiseCategory::setSelectionCode()
     * @uses JP_CruiseCategory::setRatePlanCode()
     * @param \ArrayType\ArrayOfJP_Price $prices
     * @param \StructType\JP_CruiseAdditionalElements $additionalElements
     * @param \ArrayType\ArrayOfJP_CruiseCabin $cabins
     * @param string $name
     * @param \StructType\JP_Description $description
     * @param \ArrayType\ArrayOfString1 $images
     * @param \ArrayType\ArrayOfJP_ImageLong $imagesLong
     * @param string $code
     * @param string $deckLoc
     * @param string $selectionCode
     * @param string $ratePlanCode
     */
    public function __construct(\ArrayType\ArrayOfJP_Price $prices = null, \StructType\JP_CruiseAdditionalElements $additionalElements = null, \ArrayType\ArrayOfJP_CruiseCabin $cabins = null, $name = null, \StructType\JP_Description $description = null, \ArrayType\ArrayOfString1 $images = null, \ArrayType\ArrayOfJP_ImageLong $imagesLong = null, $code = null, $deckLoc = null, $selectionCode = null, $ratePlanCode = null)
    {
        $this
            ->setPrices($prices)
            ->setAdditionalElements($additionalElements)
            ->setCabins($cabins)
            ->setName($name)
            ->setDescription($description)
            ->setImages($images)
            ->setImagesLong($imagesLong)
            ->setCode($code)
            ->setDeckLoc($deckLoc)
            ->setSelectionCode($selectionCode)
            ->setRatePlanCode($ratePlanCode);
    }
    /**
     * Get Prices value
     * @return \ArrayType\ArrayOfJP_Price|null
     */
    public function getPrices()
    {
        return $this->Prices;
    }
    /**
     * Set Prices value
     * @param \ArrayType\ArrayOfJP_Price $prices
     * @return \StructType\JP_CruiseCategory
     */
    public function setPrices(\ArrayType\ArrayOfJP_Price $prices = null)
    {
        $this->Prices = $prices;
        return $this;
    }
    /**
     * Get AdditionalElements value
     * @return \StructType\JP_CruiseAdditionalElements|null
     */
    public function getAdditionalElements()
    {
        return $this->AdditionalElements;
    }
    /**
     * Set AdditionalElements value
     * @param \StructType\JP_CruiseAdditionalElements $additionalElements
     * @return \StructType\JP_CruiseCategory
     */
    public function setAdditionalElements(\StructType\JP_CruiseAdditionalElements $additionalElements = null)
    {
        $this->AdditionalElements = $additionalElements;
        return $this;
    }
    /**
     * Get Cabins value
     * @return \ArrayType\ArrayOfJP_CruiseCabin|null
     */
    public function getCabins()
    {
        return $this->Cabins;
    }
    /**
     * Set Cabins value
     * @param \ArrayType\ArrayOfJP_CruiseCabin $cabins
     * @return \StructType\JP_CruiseCategory
     */
    public function setCabins(\ArrayType\ArrayOfJP_CruiseCabin $cabins = null)
    {
        $this->Cabins = $cabins;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\JP_CruiseCategory
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return \StructType\JP_Description|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param \StructType\JP_Description $description
     * @return \StructType\JP_CruiseCategory
     */
    public function setDescription(\StructType\JP_Description $description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Images value
     * @return \ArrayType\ArrayOfString1|null
     */
    public function getImages()
    {
        return $this->Images;
    }
    /**
     * Set Images value
     * @param \ArrayType\ArrayOfString1 $images
     * @return \StructType\JP_CruiseCategory
     */
    public function setImages(\ArrayType\ArrayOfString1 $images = null)
    {
        $this->Images = $images;
        return $this;
    }
    /**
     * Get ImagesLong value
     * @return \ArrayType\ArrayOfJP_ImageLong|null
     */
    public function getImagesLong()
    {
        return $this->ImagesLong;
    }
    /**
     * Set ImagesLong value
     * @param \ArrayType\ArrayOfJP_ImageLong $imagesLong
     * @return \StructType\JP_CruiseCategory
     */
    public function setImagesLong(\ArrayType\ArrayOfJP_ImageLong $imagesLong = null)
    {
        $this->ImagesLong = $imagesLong;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_CruiseCategory
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get DeckLoc value
     * @return string|null
     */
    public function getDeckLoc()
    {
        return $this->DeckLoc;
    }
    /**
     * Set DeckLoc value
     * @param string $deckLoc
     * @return \StructType\JP_CruiseCategory
     */
    public function setDeckLoc($deckLoc = null)
    {
        // validation for constraint: string
        if (!is_null($deckLoc) && !is_string($deckLoc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deckLoc)), __LINE__);
        }
        $this->DeckLoc = $deckLoc;
        return $this;
    }
    /**
     * Get SelectionCode value
     * @return string|null
     */
    public function getSelectionCode()
    {
        return $this->SelectionCode;
    }
    /**
     * Set SelectionCode value
     * @param string $selectionCode
     * @return \StructType\JP_CruiseCategory
     */
    public function setSelectionCode($selectionCode = null)
    {
        // validation for constraint: string
        if (!is_null($selectionCode) && !is_string($selectionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($selectionCode)), __LINE__);
        }
        $this->SelectionCode = $selectionCode;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \StructType\JP_CruiseCategory
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_CruiseCategory
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
