<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfString1 ArrayType
 * @subpackage Arrays
 */
class ArrayOfString1 extends AbstractStructArrayBase
{
    /**
     * The Image
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Image;
    /**
     * Constructor method for ArrayOfString1
     * @uses ArrayOfString1::setImage()
     * @param string[] $image
     */
    public function __construct(array $image = array())
    {
        $this
            ->setImage($image);
    }
    /**
     * Get Image value
     * @return string[]|null
     */
    public function getImage()
    {
        return $this->Image;
    }
    /**
     * Set Image value
     * @throws \InvalidArgumentException
     * @param string[] $image
     * @return \ArrayType\ArrayOfString1
     */
    public function setImage(array $image = array())
    {
        foreach ($image as $arrayOfString1ImageItem) {
            // validation for constraint: itemType
            if (!is_string($arrayOfString1ImageItem)) {
                throw new \InvalidArgumentException(sprintf('The Image property can only contain items of string, "%s" given', is_object($arrayOfString1ImageItem) ? get_class($arrayOfString1ImageItem) : gettype($arrayOfString1ImageItem)), __LINE__);
            }
        }
        $this->Image = $image;
        return $this;
    }
    /**
     * Add item to Image value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ArrayType\ArrayOfString1
     */
    public function addToImage($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Image property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Image[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Image
     */
    public function getAttributeName()
    {
        return 'Image';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfString1
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
