<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_TransportCheckAvailResult StructType
 * @subpackage Structs
 */
class JP_TransportCheckAvailResult extends AbstractStructBase
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Status;
    /**
     * The LowCost
     * Meta information extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $LowCost;
    /**
     * The PriceInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_TransportPriceInformation
     */
    public $PriceInformation;
    /**
     * The OptionalElements
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_OptionalElements
     */
    public $OptionalElements;
    /**
     * The Direction
     * @var string
     */
    public $Direction;
    /**
     * The RatePlanCode
     * @var string
     */
    public $RatePlanCode;
    /**
     * Constructor method for JP_TransportCheckAvailResult
     * @uses JP_TransportCheckAvailResult::setStatus()
     * @uses JP_TransportCheckAvailResult::setLowCost()
     * @uses JP_TransportCheckAvailResult::setPriceInformation()
     * @uses JP_TransportCheckAvailResult::setOptionalElements()
     * @uses JP_TransportCheckAvailResult::setDirection()
     * @uses JP_TransportCheckAvailResult::setRatePlanCode()
     * @param string $status
     * @param bool $lowCost
     * @param \StructType\JP_TransportPriceInformation $priceInformation
     * @param \StructType\JP_OptionalElements $optionalElements
     * @param string $direction
     * @param string $ratePlanCode
     */
    public function __construct($status = null, $lowCost = null, \StructType\JP_TransportPriceInformation $priceInformation = null, \StructType\JP_OptionalElements $optionalElements = null, $direction = null, $ratePlanCode = null)
    {
        $this
            ->setStatus($status)
            ->setLowCost($lowCost)
            ->setPriceInformation($priceInformation)
            ->setOptionalElements($optionalElements)
            ->setDirection($direction)
            ->setRatePlanCode($ratePlanCode);
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\JP_AvailStatus::valueIsValid()
     * @uses \EnumType\JP_AvailStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\JP_TransportCheckAvailResult
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_AvailStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JP_AvailStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\JP_AvailStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get LowCost value
     * @return bool
     */
    public function getLowCost()
    {
        return $this->LowCost;
    }
    /**
     * Set LowCost value
     * @param bool $lowCost
     * @return \StructType\JP_TransportCheckAvailResult
     */
    public function setLowCost($lowCost = null)
    {
        // validation for constraint: boolean
        if (!is_null($lowCost) && !is_bool($lowCost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($lowCost, true), gettype($lowCost)), __LINE__);
        }
        $this->LowCost = $lowCost;
        return $this;
    }
    /**
     * Get PriceInformation value
     * @return \StructType\JP_TransportPriceInformation|null
     */
    public function getPriceInformation()
    {
        return $this->PriceInformation;
    }
    /**
     * Set PriceInformation value
     * @param \StructType\JP_TransportPriceInformation $priceInformation
     * @return \StructType\JP_TransportCheckAvailResult
     */
    public function setPriceInformation(\StructType\JP_TransportPriceInformation $priceInformation = null)
    {
        $this->PriceInformation = $priceInformation;
        return $this;
    }
    /**
     * Get OptionalElements value
     * @return \StructType\JP_OptionalElements|null
     */
    public function getOptionalElements()
    {
        return $this->OptionalElements;
    }
    /**
     * Set OptionalElements value
     * @param \StructType\JP_OptionalElements $optionalElements
     * @return \StructType\JP_TransportCheckAvailResult
     */
    public function setOptionalElements(\StructType\JP_OptionalElements $optionalElements = null)
    {
        $this->OptionalElements = $optionalElements;
        return $this;
    }
    /**
     * Get Direction value
     * @return string|null
     */
    public function getDirection()
    {
        return $this->Direction;
    }
    /**
     * Set Direction value
     * @param string $direction
     * @return \StructType\JP_TransportCheckAvailResult
     */
    public function setDirection($direction = null)
    {
        // validation for constraint: string
        if (!is_null($direction) && !is_string($direction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($direction, true), gettype($direction)), __LINE__);
        }
        $this->Direction = $direction;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \StructType\JP_TransportCheckAvailResult
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanCode, true), gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
}
