<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_RentacarPriceInformation StructType
 * @subpackage Structs
 */
class JP_RentacarPriceInformation extends AbstractStructBase
{
    /**
     * The Prices
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Price
     */
    public $Prices;
    /**
     * The SaleContractName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SaleContractName;
    /**
     * The CostContractName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CostContractName;
    /**
     * The AdditionalElements
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_RentacarAdditionalElements
     */
    public $AdditionalElements;
    /**
     * The BillingOrganization
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_BillingOrganization
     */
    public $BillingOrganization;
    /**
     * Constructor method for JP_RentacarPriceInformation
     * @uses JP_RentacarPriceInformation::setPrices()
     * @uses JP_RentacarPriceInformation::setSaleContractName()
     * @uses JP_RentacarPriceInformation::setCostContractName()
     * @uses JP_RentacarPriceInformation::setAdditionalElements()
     * @uses JP_RentacarPriceInformation::setBillingOrganization()
     * @param \ArrayType\ArrayOfJP_Price $prices
     * @param string $saleContractName
     * @param string $costContractName
     * @param \StructType\JP_RentacarAdditionalElements $additionalElements
     * @param \StructType\JP_BillingOrganization $billingOrganization
     */
    public function __construct(\ArrayType\ArrayOfJP_Price $prices = null, $saleContractName = null, $costContractName = null, \StructType\JP_RentacarAdditionalElements $additionalElements = null, \StructType\JP_BillingOrganization $billingOrganization = null)
    {
        $this
            ->setPrices($prices)
            ->setSaleContractName($saleContractName)
            ->setCostContractName($costContractName)
            ->setAdditionalElements($additionalElements)
            ->setBillingOrganization($billingOrganization);
    }
    /**
     * Get Prices value
     * @return \ArrayType\ArrayOfJP_Price|null
     */
    public function getPrices()
    {
        return $this->Prices;
    }
    /**
     * Set Prices value
     * @param \ArrayType\ArrayOfJP_Price $prices
     * @return \StructType\JP_RentacarPriceInformation
     */
    public function setPrices(\ArrayType\ArrayOfJP_Price $prices = null)
    {
        $this->Prices = $prices;
        return $this;
    }
    /**
     * Get SaleContractName value
     * @return string|null
     */
    public function getSaleContractName()
    {
        return $this->SaleContractName;
    }
    /**
     * Set SaleContractName value
     * @param string $saleContractName
     * @return \StructType\JP_RentacarPriceInformation
     */
    public function setSaleContractName($saleContractName = null)
    {
        // validation for constraint: string
        if (!is_null($saleContractName) && !is_string($saleContractName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleContractName, true), gettype($saleContractName)), __LINE__);
        }
        $this->SaleContractName = $saleContractName;
        return $this;
    }
    /**
     * Get CostContractName value
     * @return string|null
     */
    public function getCostContractName()
    {
        return $this->CostContractName;
    }
    /**
     * Set CostContractName value
     * @param string $costContractName
     * @return \StructType\JP_RentacarPriceInformation
     */
    public function setCostContractName($costContractName = null)
    {
        // validation for constraint: string
        if (!is_null($costContractName) && !is_string($costContractName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($costContractName, true), gettype($costContractName)), __LINE__);
        }
        $this->CostContractName = $costContractName;
        return $this;
    }
    /**
     * Get AdditionalElements value
     * @return \StructType\JP_RentacarAdditionalElements|null
     */
    public function getAdditionalElements()
    {
        return $this->AdditionalElements;
    }
    /**
     * Set AdditionalElements value
     * @param \StructType\JP_RentacarAdditionalElements $additionalElements
     * @return \StructType\JP_RentacarPriceInformation
     */
    public function setAdditionalElements(\StructType\JP_RentacarAdditionalElements $additionalElements = null)
    {
        $this->AdditionalElements = $additionalElements;
        return $this;
    }
    /**
     * Get BillingOrganization value
     * @return \StructType\JP_BillingOrganization|null
     */
    public function getBillingOrganization()
    {
        return $this->BillingOrganization;
    }
    /**
     * Set BillingOrganization value
     * @param \StructType\JP_BillingOrganization $billingOrganization
     * @return \StructType\JP_RentacarPriceInformation
     */
    public function setBillingOrganization(\StructType\JP_BillingOrganization $billingOrganization = null)
    {
        $this->BillingOrganization = $billingOrganization;
        return $this;
    }
}
