<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_RentacarOption StructType
 * @subpackage Structs
 */
class JP_RentacarOption extends AbstractStructBase
{
    /**
     * The RentacarInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_RentacarInfo
     */
    public $RentacarInfo;
    /**
     * The Prices
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Price
     */
    public $Prices;
    /**
     * The CancellationPolicy
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_CancellationPolicyRules[]
     */
    public $CancellationPolicy;
    /**
     * The ContractInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_RentacarSaleContract
     */
    public $ContractInfo;
    /**
     * The AdditionalElements
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_RentacarAdditionalElements
     */
    public $AdditionalElements;
    /**
     * The OptionalElements
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_RentacarOptionalElements
     */
    public $OptionalElements;
    /**
     * The PickUpCode
     * @var string
     */
    public $PickUpCode;
    /**
     * The DropOffCode
     * @var string
     */
    public $DropOffCode;
    /**
     * The AcrissCode
     * @var string
     */
    public $AcrissCode;
    /**
     * The RatePlanCode
     * @var string
     */
    public $RatePlanCode;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * The PaymentOffice
     * @var bool
     */
    public $PaymentOffice;
    /**
     * Constructor method for JP_RentacarOption
     * @uses JP_RentacarOption::setRentacarInfo()
     * @uses JP_RentacarOption::setPrices()
     * @uses JP_RentacarOption::setCancellationPolicy()
     * @uses JP_RentacarOption::setContractInfo()
     * @uses JP_RentacarOption::setAdditionalElements()
     * @uses JP_RentacarOption::setOptionalElements()
     * @uses JP_RentacarOption::setPickUpCode()
     * @uses JP_RentacarOption::setDropOffCode()
     * @uses JP_RentacarOption::setAcrissCode()
     * @uses JP_RentacarOption::setRatePlanCode()
     * @uses JP_RentacarOption::setStatus()
     * @uses JP_RentacarOption::setPaymentOffice()
     * @param \StructType\JP_RentacarInfo $rentacarInfo
     * @param \ArrayType\ArrayOfJP_Price $prices
     * @param \StructType\JP_CancellationPolicyRules[] $cancellationPolicy
     * @param \StructType\JP_RentacarSaleContract $contractInfo
     * @param \StructType\JP_RentacarAdditionalElements $additionalElements
     * @param \StructType\JP_RentacarOptionalElements $optionalElements
     * @param string $pickUpCode
     * @param string $dropOffCode
     * @param string $acrissCode
     * @param string $ratePlanCode
     * @param string $status
     * @param bool $paymentOffice
     */
    public function __construct(\StructType\JP_RentacarInfo $rentacarInfo = null, \ArrayType\ArrayOfJP_Price $prices = null, array $cancellationPolicy = array(), \StructType\JP_RentacarSaleContract $contractInfo = null, \StructType\JP_RentacarAdditionalElements $additionalElements = null, \StructType\JP_RentacarOptionalElements $optionalElements = null, $pickUpCode = null, $dropOffCode = null, $acrissCode = null, $ratePlanCode = null, $status = null, $paymentOffice = null)
    {
        $this
            ->setRentacarInfo($rentacarInfo)
            ->setPrices($prices)
            ->setCancellationPolicy($cancellationPolicy)
            ->setContractInfo($contractInfo)
            ->setAdditionalElements($additionalElements)
            ->setOptionalElements($optionalElements)
            ->setPickUpCode($pickUpCode)
            ->setDropOffCode($dropOffCode)
            ->setAcrissCode($acrissCode)
            ->setRatePlanCode($ratePlanCode)
            ->setStatus($status)
            ->setPaymentOffice($paymentOffice);
    }
    /**
     * Get RentacarInfo value
     * @return \StructType\JP_RentacarInfo|null
     */
    public function getRentacarInfo()
    {
        return $this->RentacarInfo;
    }
    /**
     * Set RentacarInfo value
     * @param \StructType\JP_RentacarInfo $rentacarInfo
     * @return \StructType\JP_RentacarOption
     */
    public function setRentacarInfo(\StructType\JP_RentacarInfo $rentacarInfo = null)
    {
        $this->RentacarInfo = $rentacarInfo;
        return $this;
    }
    /**
     * Get Prices value
     * @return \ArrayType\ArrayOfJP_Price|null
     */
    public function getPrices()
    {
        return $this->Prices;
    }
    /**
     * Set Prices value
     * @param \ArrayType\ArrayOfJP_Price $prices
     * @return \StructType\JP_RentacarOption
     */
    public function setPrices(\ArrayType\ArrayOfJP_Price $prices = null)
    {
        $this->Prices = $prices;
        return $this;
    }
    /**
     * Get CancellationPolicy value
     * @return \StructType\JP_CancellationPolicyRules[]|null
     */
    public function getCancellationPolicy()
    {
        return $this->CancellationPolicy;
    }
    /**
     * This method is responsible for validating the values passed to the setCancellationPolicy method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCancellationPolicy method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCancellationPolicyForArrayConstraintsFromSetCancellationPolicy(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $jP_RentacarOptionCancellationPolicyItem) {
            // validation for constraint: itemType
            if (!$jP_RentacarOptionCancellationPolicyItem instanceof \StructType\JP_CancellationPolicyRules) {
                $invalidValues[] = is_object($jP_RentacarOptionCancellationPolicyItem) ? get_class($jP_RentacarOptionCancellationPolicyItem) : sprintf('%s(%s)', gettype($jP_RentacarOptionCancellationPolicyItem), var_export($jP_RentacarOptionCancellationPolicyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CancellationPolicy property can only contain items of type \StructType\JP_CancellationPolicyRules, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CancellationPolicy value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_CancellationPolicyRules[] $cancellationPolicy
     * @return \StructType\JP_RentacarOption
     */
    public function setCancellationPolicy(array $cancellationPolicy = array())
    {
        // validation for constraint: array
        if ('' !== ($cancellationPolicyArrayErrorMessage = self::validateCancellationPolicyForArrayConstraintsFromSetCancellationPolicy($cancellationPolicy))) {
            throw new \InvalidArgumentException($cancellationPolicyArrayErrorMessage, __LINE__);
        }
        $this->CancellationPolicy = $cancellationPolicy;
        return $this;
    }
    /**
     * Add item to CancellationPolicy value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_CancellationPolicyRules $item
     * @return \StructType\JP_RentacarOption
     */
    public function addToCancellationPolicy(\StructType\JP_CancellationPolicyRules $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_CancellationPolicyRules) {
            throw new \InvalidArgumentException(sprintf('The CancellationPolicy property can only contain items of type \StructType\JP_CancellationPolicyRules, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CancellationPolicy[] = $item;
        return $this;
    }
    /**
     * Get ContractInfo value
     * @return \StructType\JP_RentacarSaleContract|null
     */
    public function getContractInfo()
    {
        return $this->ContractInfo;
    }
    /**
     * Set ContractInfo value
     * @param \StructType\JP_RentacarSaleContract $contractInfo
     * @return \StructType\JP_RentacarOption
     */
    public function setContractInfo(\StructType\JP_RentacarSaleContract $contractInfo = null)
    {
        $this->ContractInfo = $contractInfo;
        return $this;
    }
    /**
     * Get AdditionalElements value
     * @return \StructType\JP_RentacarAdditionalElements|null
     */
    public function getAdditionalElements()
    {
        return $this->AdditionalElements;
    }
    /**
     * Set AdditionalElements value
     * @param \StructType\JP_RentacarAdditionalElements $additionalElements
     * @return \StructType\JP_RentacarOption
     */
    public function setAdditionalElements(\StructType\JP_RentacarAdditionalElements $additionalElements = null)
    {
        $this->AdditionalElements = $additionalElements;
        return $this;
    }
    /**
     * Get OptionalElements value
     * @return \StructType\JP_RentacarOptionalElements|null
     */
    public function getOptionalElements()
    {
        return $this->OptionalElements;
    }
    /**
     * Set OptionalElements value
     * @param \StructType\JP_RentacarOptionalElements $optionalElements
     * @return \StructType\JP_RentacarOption
     */
    public function setOptionalElements(\StructType\JP_RentacarOptionalElements $optionalElements = null)
    {
        $this->OptionalElements = $optionalElements;
        return $this;
    }
    /**
     * Get PickUpCode value
     * @return string|null
     */
    public function getPickUpCode()
    {
        return $this->PickUpCode;
    }
    /**
     * Set PickUpCode value
     * @param string $pickUpCode
     * @return \StructType\JP_RentacarOption
     */
    public function setPickUpCode($pickUpCode = null)
    {
        // validation for constraint: string
        if (!is_null($pickUpCode) && !is_string($pickUpCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickUpCode, true), gettype($pickUpCode)), __LINE__);
        }
        $this->PickUpCode = $pickUpCode;
        return $this;
    }
    /**
     * Get DropOffCode value
     * @return string|null
     */
    public function getDropOffCode()
    {
        return $this->DropOffCode;
    }
    /**
     * Set DropOffCode value
     * @param string $dropOffCode
     * @return \StructType\JP_RentacarOption
     */
    public function setDropOffCode($dropOffCode = null)
    {
        // validation for constraint: string
        if (!is_null($dropOffCode) && !is_string($dropOffCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dropOffCode, true), gettype($dropOffCode)), __LINE__);
        }
        $this->DropOffCode = $dropOffCode;
        return $this;
    }
    /**
     * Get AcrissCode value
     * @return string|null
     */
    public function getAcrissCode()
    {
        return $this->AcrissCode;
    }
    /**
     * Set AcrissCode value
     * @param string $acrissCode
     * @return \StructType\JP_RentacarOption
     */
    public function setAcrissCode($acrissCode = null)
    {
        // validation for constraint: string
        if (!is_null($acrissCode) && !is_string($acrissCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acrissCode, true), gettype($acrissCode)), __LINE__);
        }
        $this->AcrissCode = $acrissCode;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \StructType\JP_RentacarOption
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanCode, true), gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\JP_AvailStatus::valueIsValid()
     * @uses \EnumType\JP_AvailStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\JP_RentacarOption
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_AvailStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JP_AvailStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\JP_AvailStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get PaymentOffice value
     * @return bool|null
     */
    public function getPaymentOffice()
    {
        return $this->PaymentOffice;
    }
    /**
     * Set PaymentOffice value
     * @param bool $paymentOffice
     * @return \StructType\JP_RentacarOption
     */
    public function setPaymentOffice($paymentOffice = null)
    {
        // validation for constraint: boolean
        if (!is_null($paymentOffice) && !is_bool($paymentOffice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($paymentOffice, true), gettype($paymentOffice)), __LINE__);
        }
        $this->PaymentOffice = $paymentOffice;
        return $this;
    }
}
