<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_PickUpPoint StructType
 * @subpackage Structs
 */
class JP_PickUpPoint extends AbstractStructBase
{
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address;
    /**
     * The DestinationZone
     * @var string
     */
    public $DestinationZone;
    /**
     * The MeetingTime
     * @var string
     */
    public $MeetingTime;
    /**
     * Constructor method for JP_PickUpPoint
     * @uses JP_PickUpPoint::setAddress()
     * @uses JP_PickUpPoint::setDestinationZone()
     * @uses JP_PickUpPoint::setMeetingTime()
     * @param string $address
     * @param string $destinationZone
     * @param string $meetingTime
     */
    public function __construct($address = null, $destinationZone = null, $meetingTime = null)
    {
        $this
            ->setAddress($address)
            ->setDestinationZone($destinationZone)
            ->setMeetingTime($meetingTime);
    }
    /**
     * Get Address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \StructType\JP_PickUpPoint
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Get DestinationZone value
     * @return string|null
     */
    public function getDestinationZone()
    {
        return $this->DestinationZone;
    }
    /**
     * Set DestinationZone value
     * @param string $destinationZone
     * @return \StructType\JP_PickUpPoint
     */
    public function setDestinationZone($destinationZone = null)
    {
        // validation for constraint: string
        if (!is_null($destinationZone) && !is_string($destinationZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationZone, true), gettype($destinationZone)), __LINE__);
        }
        $this->DestinationZone = $destinationZone;
        return $this;
    }
    /**
     * Get MeetingTime value
     * @return string|null
     */
    public function getMeetingTime()
    {
        return $this->MeetingTime;
    }
    /**
     * Set MeetingTime value
     * @param string $meetingTime
     * @return \StructType\JP_PickUpPoint
     */
    public function setMeetingTime($meetingTime = null)
    {
        // validation for constraint: string
        if (!is_null($meetingTime) && !is_string($meetingTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($meetingTime, true), gettype($meetingTime)), __LINE__);
        }
        $this->MeetingTime = $meetingTime;
        return $this;
    }
}
