<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_TransportTicketInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_TransportTicketInfo extends AbstractStructArrayBase
{
    /**
     * The Transport
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_TransportTicketInfo[]
     */
    public $Transport;
    /**
     * Constructor method for ArrayOfJP_TransportTicketInfo
     * @uses ArrayOfJP_TransportTicketInfo::setTransport()
     * @param \StructType\JP_TransportTicketInfo[] $transport
     */
    public function __construct(array $transport = array())
    {
        $this
            ->setTransport($transport);
    }
    /**
     * Get Transport value
     * @return \StructType\JP_TransportTicketInfo[]|null
     */
    public function getTransport()
    {
        return $this->Transport;
    }
    /**
     * This method is responsible for validating the values passed to the setTransport method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTransport method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTransportForArrayConstraintsFromSetTransport(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfJP_TransportTicketInfoTransportItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_TransportTicketInfoTransportItem instanceof \StructType\JP_TransportTicketInfo) {
                $invalidValues[] = is_object($arrayOfJP_TransportTicketInfoTransportItem) ? get_class($arrayOfJP_TransportTicketInfoTransportItem) : sprintf('%s(%s)', gettype($arrayOfJP_TransportTicketInfoTransportItem), var_export($arrayOfJP_TransportTicketInfoTransportItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Transport property can only contain items of type \StructType\JP_TransportTicketInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Transport value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_TransportTicketInfo[] $transport
     * @return \ArrayType\ArrayOfJP_TransportTicketInfo
     */
    public function setTransport(array $transport = array())
    {
        // validation for constraint: array
        if ('' !== ($transportArrayErrorMessage = self::validateTransportForArrayConstraintsFromSetTransport($transport))) {
            throw new \InvalidArgumentException($transportArrayErrorMessage, __LINE__);
        }
        $this->Transport = $transport;
        return $this;
    }
    /**
     * Add item to Transport value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_TransportTicketInfo $item
     * @return \ArrayType\ArrayOfJP_TransportTicketInfo
     */
    public function addToTransport(\StructType\JP_TransportTicketInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_TransportTicketInfo) {
            throw new \InvalidArgumentException(sprintf('The Transport property can only contain items of type \StructType\JP_TransportTicketInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Transport[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_TransportTicketInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_TransportTicketInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_TransportTicketInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_TransportTicketInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_TransportTicketInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Transport
     */
    public function getAttributeName()
    {
        return 'Transport';
    }
}
