<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_ServiceDate StructType
 * @subpackage Structs
 */
class JP_ServiceDate extends AbstractStructBase
{
    /**
     * The Start
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Start;
    /**
     * The ModifyCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_BookingCode
     */
    public $ModifyCode;
    /**
     * The InfoDates
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_ServiceInfoDate
     */
    public $InfoDates;
    /**
     * The Prices
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Price
     */
    public $Prices;
    /**
     * The Contracts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_ServiceContract
     */
    public $Contracts;
    /**
     * The SupplierName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SupplierName;
    /**
     * The AdditionalElements
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_ServiceAdditionalElements
     */
    public $AdditionalElements;
    /**
     * The OptionalElements
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_ServiceOptionalElements
     */
    public $OptionalElements;
    /**
     * The End
     * @var string
     */
    public $End;
    /**
     * The Duration
     * @var int
     */
    public $Duration;
    /**
     * The RatePlanCode
     * @var string
     */
    public $RatePlanCode;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * Constructor method for JP_ServiceDate
     * @uses JP_ServiceDate::setStart()
     * @uses JP_ServiceDate::setModifyCode()
     * @uses JP_ServiceDate::setInfoDates()
     * @uses JP_ServiceDate::setPrices()
     * @uses JP_ServiceDate::setContracts()
     * @uses JP_ServiceDate::setSupplierName()
     * @uses JP_ServiceDate::setAdditionalElements()
     * @uses JP_ServiceDate::setOptionalElements()
     * @uses JP_ServiceDate::setEnd()
     * @uses JP_ServiceDate::setDuration()
     * @uses JP_ServiceDate::setRatePlanCode()
     * @uses JP_ServiceDate::setStatus()
     * @param string $start
     * @param \StructType\JP_BookingCode $modifyCode
     * @param \ArrayType\ArrayOfJP_ServiceInfoDate $infoDates
     * @param \ArrayType\ArrayOfJP_Price $prices
     * @param \ArrayType\ArrayOfJP_ServiceContract $contracts
     * @param string $supplierName
     * @param \StructType\JP_ServiceAdditionalElements $additionalElements
     * @param \StructType\JP_ServiceOptionalElements $optionalElements
     * @param string $end
     * @param int $duration
     * @param string $ratePlanCode
     * @param string $status
     */
    public function __construct($start = null, \StructType\JP_BookingCode $modifyCode = null, \ArrayType\ArrayOfJP_ServiceInfoDate $infoDates = null, \ArrayType\ArrayOfJP_Price $prices = null, \ArrayType\ArrayOfJP_ServiceContract $contracts = null, $supplierName = null, \StructType\JP_ServiceAdditionalElements $additionalElements = null, \StructType\JP_ServiceOptionalElements $optionalElements = null, $end = null, $duration = null, $ratePlanCode = null, $status = null)
    {
        $this
            ->setStart($start)
            ->setModifyCode($modifyCode)
            ->setInfoDates($infoDates)
            ->setPrices($prices)
            ->setContracts($contracts)
            ->setSupplierName($supplierName)
            ->setAdditionalElements($additionalElements)
            ->setOptionalElements($optionalElements)
            ->setEnd($end)
            ->setDuration($duration)
            ->setRatePlanCode($ratePlanCode)
            ->setStatus($status);
    }
    /**
     * Get Start value
     * @return string
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\JP_ServiceDate
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get ModifyCode value
     * @return \StructType\JP_BookingCode|null
     */
    public function getModifyCode()
    {
        return $this->ModifyCode;
    }
    /**
     * Set ModifyCode value
     * @param \StructType\JP_BookingCode $modifyCode
     * @return \StructType\JP_ServiceDate
     */
    public function setModifyCode(\StructType\JP_BookingCode $modifyCode = null)
    {
        $this->ModifyCode = $modifyCode;
        return $this;
    }
    /**
     * Get InfoDates value
     * @return \ArrayType\ArrayOfJP_ServiceInfoDate|null
     */
    public function getInfoDates()
    {
        return $this->InfoDates;
    }
    /**
     * Set InfoDates value
     * @param \ArrayType\ArrayOfJP_ServiceInfoDate $infoDates
     * @return \StructType\JP_ServiceDate
     */
    public function setInfoDates(\ArrayType\ArrayOfJP_ServiceInfoDate $infoDates = null)
    {
        $this->InfoDates = $infoDates;
        return $this;
    }
    /**
     * Get Prices value
     * @return \ArrayType\ArrayOfJP_Price|null
     */
    public function getPrices()
    {
        return $this->Prices;
    }
    /**
     * Set Prices value
     * @param \ArrayType\ArrayOfJP_Price $prices
     * @return \StructType\JP_ServiceDate
     */
    public function setPrices(\ArrayType\ArrayOfJP_Price $prices = null)
    {
        $this->Prices = $prices;
        return $this;
    }
    /**
     * Get Contracts value
     * @return \ArrayType\ArrayOfJP_ServiceContract|null
     */
    public function getContracts()
    {
        return $this->Contracts;
    }
    /**
     * Set Contracts value
     * @param \ArrayType\ArrayOfJP_ServiceContract $contracts
     * @return \StructType\JP_ServiceDate
     */
    public function setContracts(\ArrayType\ArrayOfJP_ServiceContract $contracts = null)
    {
        $this->Contracts = $contracts;
        return $this;
    }
    /**
     * Get SupplierName value
     * @return string|null
     */
    public function getSupplierName()
    {
        return $this->SupplierName;
    }
    /**
     * Set SupplierName value
     * @param string $supplierName
     * @return \StructType\JP_ServiceDate
     */
    public function setSupplierName($supplierName = null)
    {
        // validation for constraint: string
        if (!is_null($supplierName) && !is_string($supplierName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierName, true), gettype($supplierName)), __LINE__);
        }
        $this->SupplierName = $supplierName;
        return $this;
    }
    /**
     * Get AdditionalElements value
     * @return \StructType\JP_ServiceAdditionalElements|null
     */
    public function getAdditionalElements()
    {
        return $this->AdditionalElements;
    }
    /**
     * Set AdditionalElements value
     * @param \StructType\JP_ServiceAdditionalElements $additionalElements
     * @return \StructType\JP_ServiceDate
     */
    public function setAdditionalElements(\StructType\JP_ServiceAdditionalElements $additionalElements = null)
    {
        $this->AdditionalElements = $additionalElements;
        return $this;
    }
    /**
     * Get OptionalElements value
     * @return \StructType\JP_ServiceOptionalElements|null
     */
    public function getOptionalElements()
    {
        return $this->OptionalElements;
    }
    /**
     * Set OptionalElements value
     * @param \StructType\JP_ServiceOptionalElements $optionalElements
     * @return \StructType\JP_ServiceDate
     */
    public function setOptionalElements(\StructType\JP_ServiceOptionalElements $optionalElements = null)
    {
        $this->OptionalElements = $optionalElements;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\JP_ServiceDate
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get Duration value
     * @return int|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param int $duration
     * @return \StructType\JP_ServiceDate
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: int
        if (!is_null($duration) && !(is_int($duration) || ctype_digit($duration))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \StructType\JP_ServiceDate
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanCode, true), gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\JP_AvailStatus::valueIsValid()
     * @uses \EnumType\JP_AvailStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\JP_ServiceDate
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_AvailStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JP_AvailStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\JP_AvailStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
}
