<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_Results StructType
 * @subpackage Structs
 */
class JP_Results extends AbstractStructBase
{
    /**
     * The CruiseResult
     * Meta information extracted from the WSDL
     * - choice: CruiseResult | ExtraInfo | FlightResult | HotelCalendarResult | HotelFutureRatesResults | HotelResult | InsuranceResult | PackageResult | RentCarResult | ServiceResult | TransferResult | TransportResult | VisaResult
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_CruiseResult
     */
    public $CruiseResult;
    /**
     * The ExtraInfo
     * Meta information extracted from the WSDL
     * - choice: CruiseResult | ExtraInfo | FlightResult | HotelCalendarResult | HotelFutureRatesResults | HotelResult | InsuranceResult | PackageResult | RentCarResult | ServiceResult | TransferResult | TransportResult | VisaResult
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var mixed
     */
    public $ExtraInfo;
    /**
     * The FlightResult
     * Meta information extracted from the WSDL
     * - choice: CruiseResult | ExtraInfo | FlightResult | HotelCalendarResult | HotelFutureRatesResults | HotelResult | InsuranceResult | PackageResult | RentCarResult | ServiceResult | TransferResult | TransportResult | VisaResult
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Flight
     */
    public $FlightResult;
    /**
     * The HotelCalendarResult
     * Meta information extracted from the WSDL
     * - choice: CruiseResult | ExtraInfo | FlightResult | HotelCalendarResult | HotelFutureRatesResults | HotelResult | InsuranceResult | PackageResult | RentCarResult | ServiceResult | TransferResult | TransportResult | VisaResult
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_HotelCalendarResult
     */
    public $HotelCalendarResult;
    /**
     * The HotelFutureRatesResults
     * Meta information extracted from the WSDL
     * - choice: CruiseResult | ExtraInfo | FlightResult | HotelCalendarResult | HotelFutureRatesResults | HotelResult | InsuranceResult | PackageResult | RentCarResult | ServiceResult | TransferResult | TransportResult | VisaResult
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_HotelFutureRatesResults
     */
    public $HotelFutureRatesResults;
    /**
     * The HotelResult
     * Meta information extracted from the WSDL
     * - choice: CruiseResult | ExtraInfo | FlightResult | HotelCalendarResult | HotelFutureRatesResults | HotelResult | InsuranceResult | PackageResult | RentCarResult | ServiceResult | TransferResult | TransportResult | VisaResult
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_HotelResult
     */
    public $HotelResult;
    /**
     * The InsuranceResult
     * Meta information extracted from the WSDL
     * - choice: CruiseResult | ExtraInfo | FlightResult | HotelCalendarResult | HotelFutureRatesResults | HotelResult | InsuranceResult | PackageResult | RentCarResult | ServiceResult | TransferResult | TransportResult | VisaResult
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_InsuranceResult
     */
    public $InsuranceResult;
    /**
     * The PackageResult
     * Meta information extracted from the WSDL
     * - choice: CruiseResult | ExtraInfo | FlightResult | HotelCalendarResult | HotelFutureRatesResults | HotelResult | InsuranceResult | PackageResult | RentCarResult | ServiceResult | TransferResult | TransportResult | VisaResult
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_PackageResult
     */
    public $PackageResult;
    /**
     * The RentCarResult
     * Meta information extracted from the WSDL
     * - choice: CruiseResult | ExtraInfo | FlightResult | HotelCalendarResult | HotelFutureRatesResults | HotelResult | InsuranceResult | PackageResult | RentCarResult | ServiceResult | TransferResult | TransportResult | VisaResult
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_RentacarResult
     */
    public $RentCarResult;
    /**
     * The ServiceResult
     * Meta information extracted from the WSDL
     * - choice: CruiseResult | ExtraInfo | FlightResult | HotelCalendarResult | HotelFutureRatesResults | HotelResult | InsuranceResult | PackageResult | RentCarResult | ServiceResult | TransferResult | TransportResult | VisaResult
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_ServiceResult
     */
    public $ServiceResult;
    /**
     * The TransferResult
     * Meta information extracted from the WSDL
     * - choice: CruiseResult | ExtraInfo | FlightResult | HotelCalendarResult | HotelFutureRatesResults | HotelResult | InsuranceResult | PackageResult | RentCarResult | ServiceResult | TransferResult | TransportResult | VisaResult
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_TransferResult
     */
    public $TransferResult;
    /**
     * The TransportResult
     * Meta information extracted from the WSDL
     * - choice: CruiseResult | ExtraInfo | FlightResult | HotelCalendarResult | HotelFutureRatesResults | HotelResult | InsuranceResult | PackageResult | RentCarResult | ServiceResult | TransferResult | TransportResult | VisaResult
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Transport
     */
    public $TransportResult;
    /**
     * The VisaResult
     * Meta information extracted from the WSDL
     * - choice: CruiseResult | ExtraInfo | FlightResult | HotelCalendarResult | HotelFutureRatesResults | HotelResult | InsuranceResult | PackageResult | RentCarResult | ServiceResult | TransferResult | TransportResult | VisaResult
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_VisaResult
     */
    public $VisaResult;
    /**
     * Constructor method for JP_Results
     * @uses JP_Results::setCruiseResult()
     * @uses JP_Results::setExtraInfo()
     * @uses JP_Results::setFlightResult()
     * @uses JP_Results::setHotelCalendarResult()
     * @uses JP_Results::setHotelFutureRatesResults()
     * @uses JP_Results::setHotelResult()
     * @uses JP_Results::setInsuranceResult()
     * @uses JP_Results::setPackageResult()
     * @uses JP_Results::setRentCarResult()
     * @uses JP_Results::setServiceResult()
     * @uses JP_Results::setTransferResult()
     * @uses JP_Results::setTransportResult()
     * @uses JP_Results::setVisaResult()
     * @param \StructType\JP_CruiseResult $cruiseResult
     * @param mixed $extraInfo
     * @param \StructType\JP_Flight $flightResult
     * @param \StructType\JP_HotelCalendarResult $hotelCalendarResult
     * @param \StructType\JP_HotelFutureRatesResults $hotelFutureRatesResults
     * @param \StructType\JP_HotelResult $hotelResult
     * @param \StructType\JP_InsuranceResult $insuranceResult
     * @param \StructType\JP_PackageResult $packageResult
     * @param \StructType\JP_RentacarResult $rentCarResult
     * @param \StructType\JP_ServiceResult $serviceResult
     * @param \StructType\JP_TransferResult $transferResult
     * @param \StructType\JP_Transport $transportResult
     * @param \StructType\JP_VisaResult $visaResult
     */
    public function __construct(\StructType\JP_CruiseResult $cruiseResult = null, $extraInfo = null, \StructType\JP_Flight $flightResult = null, \StructType\JP_HotelCalendarResult $hotelCalendarResult = null, \StructType\JP_HotelFutureRatesResults $hotelFutureRatesResults = null, \StructType\JP_HotelResult $hotelResult = null, \StructType\JP_InsuranceResult $insuranceResult = null, \StructType\JP_PackageResult $packageResult = null, \StructType\JP_RentacarResult $rentCarResult = null, \StructType\JP_ServiceResult $serviceResult = null, \StructType\JP_TransferResult $transferResult = null, \StructType\JP_Transport $transportResult = null, \StructType\JP_VisaResult $visaResult = null)
    {
        $this
            ->setCruiseResult($cruiseResult)
            ->setExtraInfo($extraInfo)
            ->setFlightResult($flightResult)
            ->setHotelCalendarResult($hotelCalendarResult)
            ->setHotelFutureRatesResults($hotelFutureRatesResults)
            ->setHotelResult($hotelResult)
            ->setInsuranceResult($insuranceResult)
            ->setPackageResult($packageResult)
            ->setRentCarResult($rentCarResult)
            ->setServiceResult($serviceResult)
            ->setTransferResult($transferResult)
            ->setTransportResult($transportResult)
            ->setVisaResult($visaResult);
    }
    /**
     * Get CruiseResult value
     * @return \StructType\JP_CruiseResult|null
     */
    public function getCruiseResult()
    {
        return isset($this->CruiseResult) ? $this->CruiseResult : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCruiseResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCruiseResult method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCruiseResultForChoiceConstraintsFromSetCruiseResult($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ExtraInfo',
            'FlightResult',
            'HotelCalendarResult',
            'HotelFutureRatesResults',
            'HotelResult',
            'InsuranceResult',
            'PackageResult',
            'RentCarResult',
            'ServiceResult',
            'TransferResult',
            'TransportResult',
            'VisaResult',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property CruiseResult can\'t be set as the property %s is already set. Only one property must be set among these properties: CruiseResult, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set CruiseResult value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\JP_CruiseResult $cruiseResult
     * @return \StructType\JP_Results
     */
    public function setCruiseResult(\StructType\JP_CruiseResult $cruiseResult = null)
    {
        // validation for constraint: choice(CruiseResult, ExtraInfo, FlightResult, HotelCalendarResult, HotelFutureRatesResults, HotelResult, InsuranceResult, PackageResult, RentCarResult, ServiceResult, TransferResult, TransportResult, VisaResult)
        if ('' !== ($cruiseResultChoiceErrorMessage = self::validateCruiseResultForChoiceConstraintsFromSetCruiseResult($cruiseResult))) {
            throw new \InvalidArgumentException($cruiseResultChoiceErrorMessage, __LINE__);
        }
        if (is_null($cruiseResult) || (is_array($cruiseResult) && empty($cruiseResult))) {
            unset($this->CruiseResult);
        } else {
            $this->CruiseResult = $cruiseResult;
        }
        return $this;
    }
    /**
     * Get ExtraInfo value
     * @return mixed|null
     */
    public function getExtraInfo()
    {
        return isset($this->ExtraInfo) ? $this->ExtraInfo : null;
    }
    /**
     * This method is responsible for validating the value passed to the setExtraInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExtraInfo method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateExtraInfoForChoiceConstraintsFromSetExtraInfo($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CruiseResult',
            'FlightResult',
            'HotelCalendarResult',
            'HotelFutureRatesResults',
            'HotelResult',
            'InsuranceResult',
            'PackageResult',
            'RentCarResult',
            'ServiceResult',
            'TransferResult',
            'TransportResult',
            'VisaResult',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ExtraInfo can\'t be set as the property %s is already set. Only one property must be set among these properties: ExtraInfo, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ExtraInfo value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param mixed $extraInfo
     * @return \StructType\JP_Results
     */
    public function setExtraInfo($extraInfo = null)
    {
        // validation for constraint: choice(CruiseResult, ExtraInfo, FlightResult, HotelCalendarResult, HotelFutureRatesResults, HotelResult, InsuranceResult, PackageResult, RentCarResult, ServiceResult, TransferResult, TransportResult, VisaResult)
        if ('' !== ($extraInfoChoiceErrorMessage = self::validateExtraInfoForChoiceConstraintsFromSetExtraInfo($extraInfo))) {
            throw new \InvalidArgumentException($extraInfoChoiceErrorMessage, __LINE__);
        }
        if (is_null($extraInfo) || (is_array($extraInfo) && empty($extraInfo))) {
            unset($this->ExtraInfo);
        } else {
            $this->ExtraInfo = $extraInfo;
        }
        return $this;
    }
    /**
     * Get FlightResult value
     * @return \StructType\JP_Flight|null
     */
    public function getFlightResult()
    {
        return isset($this->FlightResult) ? $this->FlightResult : null;
    }
    /**
     * This method is responsible for validating the value passed to the setFlightResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFlightResult method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateFlightResultForChoiceConstraintsFromSetFlightResult($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CruiseResult',
            'ExtraInfo',
            'HotelCalendarResult',
            'HotelFutureRatesResults',
            'HotelResult',
            'InsuranceResult',
            'PackageResult',
            'RentCarResult',
            'ServiceResult',
            'TransferResult',
            'TransportResult',
            'VisaResult',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property FlightResult can\'t be set as the property %s is already set. Only one property must be set among these properties: FlightResult, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set FlightResult value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Flight $flightResult
     * @return \StructType\JP_Results
     */
    public function setFlightResult(\StructType\JP_Flight $flightResult = null)
    {
        // validation for constraint: choice(CruiseResult, ExtraInfo, FlightResult, HotelCalendarResult, HotelFutureRatesResults, HotelResult, InsuranceResult, PackageResult, RentCarResult, ServiceResult, TransferResult, TransportResult, VisaResult)
        if ('' !== ($flightResultChoiceErrorMessage = self::validateFlightResultForChoiceConstraintsFromSetFlightResult($flightResult))) {
            throw new \InvalidArgumentException($flightResultChoiceErrorMessage, __LINE__);
        }
        if (is_null($flightResult) || (is_array($flightResult) && empty($flightResult))) {
            unset($this->FlightResult);
        } else {
            $this->FlightResult = $flightResult;
        }
        return $this;
    }
    /**
     * Get HotelCalendarResult value
     * @return \StructType\JP_HotelCalendarResult|null
     */
    public function getHotelCalendarResult()
    {
        return isset($this->HotelCalendarResult) ? $this->HotelCalendarResult : null;
    }
    /**
     * This method is responsible for validating the value passed to the setHotelCalendarResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotelCalendarResult method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateHotelCalendarResultForChoiceConstraintsFromSetHotelCalendarResult($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CruiseResult',
            'ExtraInfo',
            'FlightResult',
            'HotelFutureRatesResults',
            'HotelResult',
            'InsuranceResult',
            'PackageResult',
            'RentCarResult',
            'ServiceResult',
            'TransferResult',
            'TransportResult',
            'VisaResult',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property HotelCalendarResult can\'t be set as the property %s is already set. Only one property must be set among these properties: HotelCalendarResult, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set HotelCalendarResult value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\JP_HotelCalendarResult $hotelCalendarResult
     * @return \StructType\JP_Results
     */
    public function setHotelCalendarResult(\StructType\JP_HotelCalendarResult $hotelCalendarResult = null)
    {
        // validation for constraint: choice(CruiseResult, ExtraInfo, FlightResult, HotelCalendarResult, HotelFutureRatesResults, HotelResult, InsuranceResult, PackageResult, RentCarResult, ServiceResult, TransferResult, TransportResult, VisaResult)
        if ('' !== ($hotelCalendarResultChoiceErrorMessage = self::validateHotelCalendarResultForChoiceConstraintsFromSetHotelCalendarResult($hotelCalendarResult))) {
            throw new \InvalidArgumentException($hotelCalendarResultChoiceErrorMessage, __LINE__);
        }
        if (is_null($hotelCalendarResult) || (is_array($hotelCalendarResult) && empty($hotelCalendarResult))) {
            unset($this->HotelCalendarResult);
        } else {
            $this->HotelCalendarResult = $hotelCalendarResult;
        }
        return $this;
    }
    /**
     * Get HotelFutureRatesResults value
     * @return \StructType\JP_HotelFutureRatesResults|null
     */
    public function getHotelFutureRatesResults()
    {
        return isset($this->HotelFutureRatesResults) ? $this->HotelFutureRatesResults : null;
    }
    /**
     * This method is responsible for validating the value passed to the setHotelFutureRatesResults method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotelFutureRatesResults method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateHotelFutureRatesResultsForChoiceConstraintsFromSetHotelFutureRatesResults($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CruiseResult',
            'ExtraInfo',
            'FlightResult',
            'HotelCalendarResult',
            'HotelResult',
            'InsuranceResult',
            'PackageResult',
            'RentCarResult',
            'ServiceResult',
            'TransferResult',
            'TransportResult',
            'VisaResult',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property HotelFutureRatesResults can\'t be set as the property %s is already set. Only one property must be set among these properties: HotelFutureRatesResults, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set HotelFutureRatesResults value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\JP_HotelFutureRatesResults $hotelFutureRatesResults
     * @return \StructType\JP_Results
     */
    public function setHotelFutureRatesResults(\StructType\JP_HotelFutureRatesResults $hotelFutureRatesResults = null)
    {
        // validation for constraint: choice(CruiseResult, ExtraInfo, FlightResult, HotelCalendarResult, HotelFutureRatesResults, HotelResult, InsuranceResult, PackageResult, RentCarResult, ServiceResult, TransferResult, TransportResult, VisaResult)
        if ('' !== ($hotelFutureRatesResultsChoiceErrorMessage = self::validateHotelFutureRatesResultsForChoiceConstraintsFromSetHotelFutureRatesResults($hotelFutureRatesResults))) {
            throw new \InvalidArgumentException($hotelFutureRatesResultsChoiceErrorMessage, __LINE__);
        }
        if (is_null($hotelFutureRatesResults) || (is_array($hotelFutureRatesResults) && empty($hotelFutureRatesResults))) {
            unset($this->HotelFutureRatesResults);
        } else {
            $this->HotelFutureRatesResults = $hotelFutureRatesResults;
        }
        return $this;
    }
    /**
     * Get HotelResult value
     * @return \StructType\JP_HotelResult|null
     */
    public function getHotelResult()
    {
        return isset($this->HotelResult) ? $this->HotelResult : null;
    }
    /**
     * This method is responsible for validating the value passed to the setHotelResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotelResult method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateHotelResultForChoiceConstraintsFromSetHotelResult($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CruiseResult',
            'ExtraInfo',
            'FlightResult',
            'HotelCalendarResult',
            'HotelFutureRatesResults',
            'InsuranceResult',
            'PackageResult',
            'RentCarResult',
            'ServiceResult',
            'TransferResult',
            'TransportResult',
            'VisaResult',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property HotelResult can\'t be set as the property %s is already set. Only one property must be set among these properties: HotelResult, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set HotelResult value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\JP_HotelResult $hotelResult
     * @return \StructType\JP_Results
     */
    public function setHotelResult(\StructType\JP_HotelResult $hotelResult = null)
    {
        // validation for constraint: choice(CruiseResult, ExtraInfo, FlightResult, HotelCalendarResult, HotelFutureRatesResults, HotelResult, InsuranceResult, PackageResult, RentCarResult, ServiceResult, TransferResult, TransportResult, VisaResult)
        if ('' !== ($hotelResultChoiceErrorMessage = self::validateHotelResultForChoiceConstraintsFromSetHotelResult($hotelResult))) {
            throw new \InvalidArgumentException($hotelResultChoiceErrorMessage, __LINE__);
        }
        if (is_null($hotelResult) || (is_array($hotelResult) && empty($hotelResult))) {
            unset($this->HotelResult);
        } else {
            $this->HotelResult = $hotelResult;
        }
        return $this;
    }
    /**
     * Get InsuranceResult value
     * @return \StructType\JP_InsuranceResult|null
     */
    public function getInsuranceResult()
    {
        return isset($this->InsuranceResult) ? $this->InsuranceResult : null;
    }
    /**
     * This method is responsible for validating the value passed to the setInsuranceResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInsuranceResult method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateInsuranceResultForChoiceConstraintsFromSetInsuranceResult($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CruiseResult',
            'ExtraInfo',
            'FlightResult',
            'HotelCalendarResult',
            'HotelFutureRatesResults',
            'HotelResult',
            'PackageResult',
            'RentCarResult',
            'ServiceResult',
            'TransferResult',
            'TransportResult',
            'VisaResult',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property InsuranceResult can\'t be set as the property %s is already set. Only one property must be set among these properties: InsuranceResult, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set InsuranceResult value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\JP_InsuranceResult $insuranceResult
     * @return \StructType\JP_Results
     */
    public function setInsuranceResult(\StructType\JP_InsuranceResult $insuranceResult = null)
    {
        // validation for constraint: choice(CruiseResult, ExtraInfo, FlightResult, HotelCalendarResult, HotelFutureRatesResults, HotelResult, InsuranceResult, PackageResult, RentCarResult, ServiceResult, TransferResult, TransportResult, VisaResult)
        if ('' !== ($insuranceResultChoiceErrorMessage = self::validateInsuranceResultForChoiceConstraintsFromSetInsuranceResult($insuranceResult))) {
            throw new \InvalidArgumentException($insuranceResultChoiceErrorMessage, __LINE__);
        }
        if (is_null($insuranceResult) || (is_array($insuranceResult) && empty($insuranceResult))) {
            unset($this->InsuranceResult);
        } else {
            $this->InsuranceResult = $insuranceResult;
        }
        return $this;
    }
    /**
     * Get PackageResult value
     * @return \StructType\JP_PackageResult|null
     */
    public function getPackageResult()
    {
        return isset($this->PackageResult) ? $this->PackageResult : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPackageResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPackageResult method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePackageResultForChoiceConstraintsFromSetPackageResult($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CruiseResult',
            'ExtraInfo',
            'FlightResult',
            'HotelCalendarResult',
            'HotelFutureRatesResults',
            'HotelResult',
            'InsuranceResult',
            'RentCarResult',
            'ServiceResult',
            'TransferResult',
            'TransportResult',
            'VisaResult',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PackageResult can\'t be set as the property %s is already set. Only one property must be set among these properties: PackageResult, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set PackageResult value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\JP_PackageResult $packageResult
     * @return \StructType\JP_Results
     */
    public function setPackageResult(\StructType\JP_PackageResult $packageResult = null)
    {
        // validation for constraint: choice(CruiseResult, ExtraInfo, FlightResult, HotelCalendarResult, HotelFutureRatesResults, HotelResult, InsuranceResult, PackageResult, RentCarResult, ServiceResult, TransferResult, TransportResult, VisaResult)
        if ('' !== ($packageResultChoiceErrorMessage = self::validatePackageResultForChoiceConstraintsFromSetPackageResult($packageResult))) {
            throw new \InvalidArgumentException($packageResultChoiceErrorMessage, __LINE__);
        }
        if (is_null($packageResult) || (is_array($packageResult) && empty($packageResult))) {
            unset($this->PackageResult);
        } else {
            $this->PackageResult = $packageResult;
        }
        return $this;
    }
    /**
     * Get RentCarResult value
     * @return \StructType\JP_RentacarResult|null
     */
    public function getRentCarResult()
    {
        return isset($this->RentCarResult) ? $this->RentCarResult : null;
    }
    /**
     * This method is responsible for validating the value passed to the setRentCarResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRentCarResult method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateRentCarResultForChoiceConstraintsFromSetRentCarResult($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CruiseResult',
            'ExtraInfo',
            'FlightResult',
            'HotelCalendarResult',
            'HotelFutureRatesResults',
            'HotelResult',
            'InsuranceResult',
            'PackageResult',
            'ServiceResult',
            'TransferResult',
            'TransportResult',
            'VisaResult',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property RentCarResult can\'t be set as the property %s is already set. Only one property must be set among these properties: RentCarResult, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set RentCarResult value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\JP_RentacarResult $rentCarResult
     * @return \StructType\JP_Results
     */
    public function setRentCarResult(\StructType\JP_RentacarResult $rentCarResult = null)
    {
        // validation for constraint: choice(CruiseResult, ExtraInfo, FlightResult, HotelCalendarResult, HotelFutureRatesResults, HotelResult, InsuranceResult, PackageResult, RentCarResult, ServiceResult, TransferResult, TransportResult, VisaResult)
        if ('' !== ($rentCarResultChoiceErrorMessage = self::validateRentCarResultForChoiceConstraintsFromSetRentCarResult($rentCarResult))) {
            throw new \InvalidArgumentException($rentCarResultChoiceErrorMessage, __LINE__);
        }
        if (is_null($rentCarResult) || (is_array($rentCarResult) && empty($rentCarResult))) {
            unset($this->RentCarResult);
        } else {
            $this->RentCarResult = $rentCarResult;
        }
        return $this;
    }
    /**
     * Get ServiceResult value
     * @return \StructType\JP_ServiceResult|null
     */
    public function getServiceResult()
    {
        return isset($this->ServiceResult) ? $this->ServiceResult : null;
    }
    /**
     * This method is responsible for validating the value passed to the setServiceResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setServiceResult method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateServiceResultForChoiceConstraintsFromSetServiceResult($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CruiseResult',
            'ExtraInfo',
            'FlightResult',
            'HotelCalendarResult',
            'HotelFutureRatesResults',
            'HotelResult',
            'InsuranceResult',
            'PackageResult',
            'RentCarResult',
            'TransferResult',
            'TransportResult',
            'VisaResult',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ServiceResult can\'t be set as the property %s is already set. Only one property must be set among these properties: ServiceResult, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ServiceResult value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\JP_ServiceResult $serviceResult
     * @return \StructType\JP_Results
     */
    public function setServiceResult(\StructType\JP_ServiceResult $serviceResult = null)
    {
        // validation for constraint: choice(CruiseResult, ExtraInfo, FlightResult, HotelCalendarResult, HotelFutureRatesResults, HotelResult, InsuranceResult, PackageResult, RentCarResult, ServiceResult, TransferResult, TransportResult, VisaResult)
        if ('' !== ($serviceResultChoiceErrorMessage = self::validateServiceResultForChoiceConstraintsFromSetServiceResult($serviceResult))) {
            throw new \InvalidArgumentException($serviceResultChoiceErrorMessage, __LINE__);
        }
        if (is_null($serviceResult) || (is_array($serviceResult) && empty($serviceResult))) {
            unset($this->ServiceResult);
        } else {
            $this->ServiceResult = $serviceResult;
        }
        return $this;
    }
    /**
     * Get TransferResult value
     * @return \StructType\JP_TransferResult|null
     */
    public function getTransferResult()
    {
        return isset($this->TransferResult) ? $this->TransferResult : null;
    }
    /**
     * This method is responsible for validating the value passed to the setTransferResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTransferResult method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateTransferResultForChoiceConstraintsFromSetTransferResult($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CruiseResult',
            'ExtraInfo',
            'FlightResult',
            'HotelCalendarResult',
            'HotelFutureRatesResults',
            'HotelResult',
            'InsuranceResult',
            'PackageResult',
            'RentCarResult',
            'ServiceResult',
            'TransportResult',
            'VisaResult',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property TransferResult can\'t be set as the property %s is already set. Only one property must be set among these properties: TransferResult, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set TransferResult value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\JP_TransferResult $transferResult
     * @return \StructType\JP_Results
     */
    public function setTransferResult(\StructType\JP_TransferResult $transferResult = null)
    {
        // validation for constraint: choice(CruiseResult, ExtraInfo, FlightResult, HotelCalendarResult, HotelFutureRatesResults, HotelResult, InsuranceResult, PackageResult, RentCarResult, ServiceResult, TransferResult, TransportResult, VisaResult)
        if ('' !== ($transferResultChoiceErrorMessage = self::validateTransferResultForChoiceConstraintsFromSetTransferResult($transferResult))) {
            throw new \InvalidArgumentException($transferResultChoiceErrorMessage, __LINE__);
        }
        if (is_null($transferResult) || (is_array($transferResult) && empty($transferResult))) {
            unset($this->TransferResult);
        } else {
            $this->TransferResult = $transferResult;
        }
        return $this;
    }
    /**
     * Get TransportResult value
     * @return \StructType\JP_Transport|null
     */
    public function getTransportResult()
    {
        return isset($this->TransportResult) ? $this->TransportResult : null;
    }
    /**
     * This method is responsible for validating the value passed to the setTransportResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTransportResult method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateTransportResultForChoiceConstraintsFromSetTransportResult($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CruiseResult',
            'ExtraInfo',
            'FlightResult',
            'HotelCalendarResult',
            'HotelFutureRatesResults',
            'HotelResult',
            'InsuranceResult',
            'PackageResult',
            'RentCarResult',
            'ServiceResult',
            'TransferResult',
            'VisaResult',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property TransportResult can\'t be set as the property %s is already set. Only one property must be set among these properties: TransportResult, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set TransportResult value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Transport $transportResult
     * @return \StructType\JP_Results
     */
    public function setTransportResult(\StructType\JP_Transport $transportResult = null)
    {
        // validation for constraint: choice(CruiseResult, ExtraInfo, FlightResult, HotelCalendarResult, HotelFutureRatesResults, HotelResult, InsuranceResult, PackageResult, RentCarResult, ServiceResult, TransferResult, TransportResult, VisaResult)
        if ('' !== ($transportResultChoiceErrorMessage = self::validateTransportResultForChoiceConstraintsFromSetTransportResult($transportResult))) {
            throw new \InvalidArgumentException($transportResultChoiceErrorMessage, __LINE__);
        }
        if (is_null($transportResult) || (is_array($transportResult) && empty($transportResult))) {
            unset($this->TransportResult);
        } else {
            $this->TransportResult = $transportResult;
        }
        return $this;
    }
    /**
     * Get VisaResult value
     * @return \StructType\JP_VisaResult|null
     */
    public function getVisaResult()
    {
        return isset($this->VisaResult) ? $this->VisaResult : null;
    }
    /**
     * This method is responsible for validating the value passed to the setVisaResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVisaResult method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateVisaResultForChoiceConstraintsFromSetVisaResult($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CruiseResult',
            'ExtraInfo',
            'FlightResult',
            'HotelCalendarResult',
            'HotelFutureRatesResults',
            'HotelResult',
            'InsuranceResult',
            'PackageResult',
            'RentCarResult',
            'ServiceResult',
            'TransferResult',
            'TransportResult',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property VisaResult can\'t be set as the property %s is already set. Only one property must be set among these properties: VisaResult, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set VisaResult value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\JP_VisaResult $visaResult
     * @return \StructType\JP_Results
     */
    public function setVisaResult(\StructType\JP_VisaResult $visaResult = null)
    {
        // validation for constraint: choice(CruiseResult, ExtraInfo, FlightResult, HotelCalendarResult, HotelFutureRatesResults, HotelResult, InsuranceResult, PackageResult, RentCarResult, ServiceResult, TransferResult, TransportResult, VisaResult)
        if ('' !== ($visaResultChoiceErrorMessage = self::validateVisaResultForChoiceConstraintsFromSetVisaResult($visaResult))) {
            throw new \InvalidArgumentException($visaResultChoiceErrorMessage, __LINE__);
        }
        if (is_null($visaResult) || (is_array($visaResult) && empty($visaResult))) {
            unset($this->VisaResult);
        } else {
            $this->VisaResult = $visaResult;
        }
        return $this;
    }
}
