<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_BookingListRequest StructType
 * @subpackage Structs
 */
class JP_BookingListRequest extends AbstractStructBase
{
    /**
     * The StartingBookingDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JPSOAP_DateIntervals
     */
    public $StartingBookingDate;
    /**
     * The EndingBookingDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JPSOAP_DateIntervals
     */
    public $EndingBookingDate;
    /**
     * The CancellationBookingDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JPSOAP_DateIntervals
     */
    public $CancellationBookingDate;
    /**
     * The ModificationBookingDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JPSOAP_DateIntervals
     */
    public $ModificationBookingDate;
    /**
     * The BookingDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JPSOAP_DateIntervals
     */
    public $BookingDate;
    /**
     * The ExpirationBookingDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JPSOAP_DateIntervals
     */
    public $ExpirationBookingDate;
    /**
     * The ExternalBookingReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExternalBookingReference;
    /**
     * Constructor method for JP_BookingListRequest
     * @uses JP_BookingListRequest::setStartingBookingDate()
     * @uses JP_BookingListRequest::setEndingBookingDate()
     * @uses JP_BookingListRequest::setCancellationBookingDate()
     * @uses JP_BookingListRequest::setModificationBookingDate()
     * @uses JP_BookingListRequest::setBookingDate()
     * @uses JP_BookingListRequest::setExpirationBookingDate()
     * @uses JP_BookingListRequest::setExternalBookingReference()
     * @param \StructType\JPSOAP_DateIntervals $startingBookingDate
     * @param \StructType\JPSOAP_DateIntervals $endingBookingDate
     * @param \StructType\JPSOAP_DateIntervals $cancellationBookingDate
     * @param \StructType\JPSOAP_DateIntervals $modificationBookingDate
     * @param \StructType\JPSOAP_DateIntervals $bookingDate
     * @param \StructType\JPSOAP_DateIntervals $expirationBookingDate
     * @param string $externalBookingReference
     */
    public function __construct(\StructType\JPSOAP_DateIntervals $startingBookingDate = null, \StructType\JPSOAP_DateIntervals $endingBookingDate = null, \StructType\JPSOAP_DateIntervals $cancellationBookingDate = null, \StructType\JPSOAP_DateIntervals $modificationBookingDate = null, \StructType\JPSOAP_DateIntervals $bookingDate = null, \StructType\JPSOAP_DateIntervals $expirationBookingDate = null, $externalBookingReference = null)
    {
        $this
            ->setStartingBookingDate($startingBookingDate)
            ->setEndingBookingDate($endingBookingDate)
            ->setCancellationBookingDate($cancellationBookingDate)
            ->setModificationBookingDate($modificationBookingDate)
            ->setBookingDate($bookingDate)
            ->setExpirationBookingDate($expirationBookingDate)
            ->setExternalBookingReference($externalBookingReference);
    }
    /**
     * Get StartingBookingDate value
     * @return \StructType\JPSOAP_DateIntervals|null
     */
    public function getStartingBookingDate()
    {
        return $this->StartingBookingDate;
    }
    /**
     * Set StartingBookingDate value
     * @param \StructType\JPSOAP_DateIntervals $startingBookingDate
     * @return \StructType\JP_BookingListRequest
     */
    public function setStartingBookingDate(\StructType\JPSOAP_DateIntervals $startingBookingDate = null)
    {
        $this->StartingBookingDate = $startingBookingDate;
        return $this;
    }
    /**
     * Get EndingBookingDate value
     * @return \StructType\JPSOAP_DateIntervals|null
     */
    public function getEndingBookingDate()
    {
        return $this->EndingBookingDate;
    }
    /**
     * Set EndingBookingDate value
     * @param \StructType\JPSOAP_DateIntervals $endingBookingDate
     * @return \StructType\JP_BookingListRequest
     */
    public function setEndingBookingDate(\StructType\JPSOAP_DateIntervals $endingBookingDate = null)
    {
        $this->EndingBookingDate = $endingBookingDate;
        return $this;
    }
    /**
     * Get CancellationBookingDate value
     * @return \StructType\JPSOAP_DateIntervals|null
     */
    public function getCancellationBookingDate()
    {
        return $this->CancellationBookingDate;
    }
    /**
     * Set CancellationBookingDate value
     * @param \StructType\JPSOAP_DateIntervals $cancellationBookingDate
     * @return \StructType\JP_BookingListRequest
     */
    public function setCancellationBookingDate(\StructType\JPSOAP_DateIntervals $cancellationBookingDate = null)
    {
        $this->CancellationBookingDate = $cancellationBookingDate;
        return $this;
    }
    /**
     * Get ModificationBookingDate value
     * @return \StructType\JPSOAP_DateIntervals|null
     */
    public function getModificationBookingDate()
    {
        return $this->ModificationBookingDate;
    }
    /**
     * Set ModificationBookingDate value
     * @param \StructType\JPSOAP_DateIntervals $modificationBookingDate
     * @return \StructType\JP_BookingListRequest
     */
    public function setModificationBookingDate(\StructType\JPSOAP_DateIntervals $modificationBookingDate = null)
    {
        $this->ModificationBookingDate = $modificationBookingDate;
        return $this;
    }
    /**
     * Get BookingDate value
     * @return \StructType\JPSOAP_DateIntervals|null
     */
    public function getBookingDate()
    {
        return $this->BookingDate;
    }
    /**
     * Set BookingDate value
     * @param \StructType\JPSOAP_DateIntervals $bookingDate
     * @return \StructType\JP_BookingListRequest
     */
    public function setBookingDate(\StructType\JPSOAP_DateIntervals $bookingDate = null)
    {
        $this->BookingDate = $bookingDate;
        return $this;
    }
    /**
     * Get ExpirationBookingDate value
     * @return \StructType\JPSOAP_DateIntervals|null
     */
    public function getExpirationBookingDate()
    {
        return $this->ExpirationBookingDate;
    }
    /**
     * Set ExpirationBookingDate value
     * @param \StructType\JPSOAP_DateIntervals $expirationBookingDate
     * @return \StructType\JP_BookingListRequest
     */
    public function setExpirationBookingDate(\StructType\JPSOAP_DateIntervals $expirationBookingDate = null)
    {
        $this->ExpirationBookingDate = $expirationBookingDate;
        return $this;
    }
    /**
     * Get ExternalBookingReference value
     * @return string|null
     */
    public function getExternalBookingReference()
    {
        return $this->ExternalBookingReference;
    }
    /**
     * Set ExternalBookingReference value
     * @param string $externalBookingReference
     * @return \StructType\JP_BookingListRequest
     */
    public function setExternalBookingReference($externalBookingReference = null)
    {
        // validation for constraint: string
        if (!is_null($externalBookingReference) && !is_string($externalBookingReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalBookingReference, true), gettype($externalBookingReference)), __LINE__);
        }
        $this->ExternalBookingReference = $externalBookingReference;
        return $this;
    }
}
