<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChangeFirstDaySupplement StructType
 * @subpackage Structs
 */
class ChangeFirstDaySupplement extends AbstractStructBase
{
    /**
     * The FirstDay
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $FirstDay;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * Constructor method for ChangeFirstDaySupplement
     * @uses ChangeFirstDaySupplement::setFirstDay()
     * @uses ChangeFirstDaySupplement::setCode()
     * @param int $firstDay
     * @param string $code
     */
    public function __construct($firstDay = null, $code = null)
    {
        $this
            ->setFirstDay($firstDay)
            ->setCode($code);
    }
    /**
     * Get FirstDay value
     * @return int
     */
    public function getFirstDay()
    {
        return $this->FirstDay;
    }
    /**
     * Set FirstDay value
     * @param int $firstDay
     * @return \StructType\ChangeFirstDaySupplement
     */
    public function setFirstDay($firstDay = null)
    {
        // validation for constraint: int
        if (!is_null($firstDay) && !(is_int($firstDay) || ctype_digit($firstDay))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($firstDay, true), gettype($firstDay)), __LINE__);
        }
        $this->FirstDay = $firstDay;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\ChangeFirstDaySupplement
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
}
