<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfString12 ArrayType
 * @subpackage Arrays
 */
class ArrayOfString12 extends AbstractStructArrayBase
{
    /**
     * The ModuleType
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $ModuleType;
    /**
     * Constructor method for ArrayOfString12
     * @uses ArrayOfString12::setModuleType()
     * @param string[] $moduleType
     */
    public function __construct(array $moduleType = array())
    {
        $this
            ->setModuleType($moduleType);
    }
    /**
     * Get ModuleType value
     * @return string[]|null
     */
    public function getModuleType()
    {
        return $this->ModuleType;
    }
    /**
     * This method is responsible for validating the values passed to the setModuleType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setModuleType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateModuleTypeForArrayConstraintsFromSetModuleType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfString12ModuleTypeItem) {
            // validation for constraint: itemType
            if (!is_string($arrayOfString12ModuleTypeItem)) {
                $invalidValues[] = is_object($arrayOfString12ModuleTypeItem) ? get_class($arrayOfString12ModuleTypeItem) : sprintf('%s(%s)', gettype($arrayOfString12ModuleTypeItem), var_export($arrayOfString12ModuleTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ModuleType property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ModuleType value
     * @throws \InvalidArgumentException
     * @param string[] $moduleType
     * @return \ArrayType\ArrayOfString12
     */
    public function setModuleType(array $moduleType = array())
    {
        // validation for constraint: array
        if ('' !== ($moduleTypeArrayErrorMessage = self::validateModuleTypeForArrayConstraintsFromSetModuleType($moduleType))) {
            throw new \InvalidArgumentException($moduleTypeArrayErrorMessage, __LINE__);
        }
        $this->ModuleType = $moduleType;
        return $this;
    }
    /**
     * Add item to ModuleType value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ArrayType\ArrayOfString12
     */
    public function addToModuleType($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The ModuleType property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ModuleType[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ModuleType
     */
    public function getAttributeName()
    {
        return 'ModuleType';
    }
}
