<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_Clasification ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_Clasification extends AbstractStructArrayBase
{
    /**
     * The Clasification
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_Clasification[]
     */
    public $Clasification;
    /**
     * Constructor method for ArrayOfJP_Clasification
     * @uses ArrayOfJP_Clasification::setClasification()
     * @param \StructType\JP_Clasification[] $clasification
     */
    public function __construct(array $clasification = array())
    {
        $this
            ->setClasification($clasification);
    }
    /**
     * Get Clasification value
     * @return \StructType\JP_Clasification[]|null
     */
    public function getClasification()
    {
        return $this->Clasification;
    }
    /**
     * This method is responsible for validating the values passed to the setClasification method
     * This method is willingly generated in order to preserve the one-line inline validation within the setClasification method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateClasificationForArrayConstraintsFromSetClasification(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfJP_ClasificationClasificationItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_ClasificationClasificationItem instanceof \StructType\JP_Clasification) {
                $invalidValues[] = is_object($arrayOfJP_ClasificationClasificationItem) ? get_class($arrayOfJP_ClasificationClasificationItem) : sprintf('%s(%s)', gettype($arrayOfJP_ClasificationClasificationItem), var_export($arrayOfJP_ClasificationClasificationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Clasification property can only contain items of type \StructType\JP_Clasification, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Clasification value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Clasification[] $clasification
     * @return \ArrayType\ArrayOfJP_Clasification
     */
    public function setClasification(array $clasification = array())
    {
        // validation for constraint: array
        if ('' !== ($clasificationArrayErrorMessage = self::validateClasificationForArrayConstraintsFromSetClasification($clasification))) {
            throw new \InvalidArgumentException($clasificationArrayErrorMessage, __LINE__);
        }
        $this->Clasification = $clasification;
        return $this;
    }
    /**
     * Add item to Clasification value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Clasification $item
     * @return \ArrayType\ArrayOfJP_Clasification
     */
    public function addToClasification(\StructType\JP_Clasification $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_Clasification) {
            throw new \InvalidArgumentException(sprintf('The Clasification property can only contain items of type \StructType\JP_Clasification, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Clasification[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_Clasification|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_Clasification|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_Clasification|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_Clasification|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_Clasification|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Clasification
     */
    public function getAttributeName()
    {
        return 'Clasification';
    }
}
