<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_Location ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_Location extends AbstractStructArrayBase
{
    /**
     * The Location
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_Location[]
     */
    public $Location;
    /**
     * Constructor method for ArrayOfJP_Location
     * @uses ArrayOfJP_Location::setLocation()
     * @param \StructType\JP_Location[] $location
     */
    public function __construct(array $location = array())
    {
        $this
            ->setLocation($location);
    }
    /**
     * Get Location value
     * @return \StructType\JP_Location[]|null
     */
    public function getLocation()
    {
        return $this->Location;
    }
    /**
     * This method is responsible for validating the values passed to the setLocation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLocation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLocationForArrayConstraintsFromSetLocation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfJP_LocationLocationItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_LocationLocationItem instanceof \StructType\JP_Location) {
                $invalidValues[] = is_object($arrayOfJP_LocationLocationItem) ? get_class($arrayOfJP_LocationLocationItem) : sprintf('%s(%s)', gettype($arrayOfJP_LocationLocationItem), var_export($arrayOfJP_LocationLocationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Location property can only contain items of type \StructType\JP_Location, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Location value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Location[] $location
     * @return \ArrayType\ArrayOfJP_Location
     */
    public function setLocation(array $location = array())
    {
        // validation for constraint: array
        if ('' !== ($locationArrayErrorMessage = self::validateLocationForArrayConstraintsFromSetLocation($location))) {
            throw new \InvalidArgumentException($locationArrayErrorMessage, __LINE__);
        }
        $this->Location = $location;
        return $this;
    }
    /**
     * Add item to Location value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Location $item
     * @return \ArrayType\ArrayOfJP_Location
     */
    public function addToLocation(\StructType\JP_Location $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_Location) {
            throw new \InvalidArgumentException(sprintf('The Location property can only contain items of type \StructType\JP_Location, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Location[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_Location|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_Location|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_Location|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_Location|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_Location|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Location
     */
    public function getAttributeName()
    {
        return 'Location';
    }
}
