<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_Transfer StructType
 * @subpackage Structs
 */
class JP_Transfer extends AbstractStructBase
{
    /**
     * The TransferInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_TransferInfo
     */
    public $TransferInfo;
    /**
     * The TransferOptions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_TransferOption
     */
    public $TransferOptions;
    /**
     * The TransferBookingInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_TransferBookingInfo
     */
    public $TransferBookingInfo;
    /**
     * The Origins
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Origin
     */
    public $Origins;
    /**
     * The Destinations
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Destination
     */
    public $Destinations;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The ICode
     * @var string
     */
    public $ICode;
    /**
     * The SearchMore
     * @var bool
     */
    public $SearchMore;
    /**
     * The Order
     * @var int
     */
    public $Order;
    /**
     * Constructor method for JP_Transfer
     * @uses JP_Transfer::setTransferInfo()
     * @uses JP_Transfer::setTransferOptions()
     * @uses JP_Transfer::setTransferBookingInfo()
     * @uses JP_Transfer::setOrigins()
     * @uses JP_Transfer::setDestinations()
     * @uses JP_Transfer::setCode()
     * @uses JP_Transfer::setICode()
     * @uses JP_Transfer::setSearchMore()
     * @uses JP_Transfer::setOrder()
     * @param \StructType\JP_TransferInfo $transferInfo
     * @param \ArrayType\ArrayOfJP_TransferOption $transferOptions
     * @param \StructType\JP_TransferBookingInfo $transferBookingInfo
     * @param \ArrayType\ArrayOfJP_Origin $origins
     * @param \ArrayType\ArrayOfJP_Destination $destinations
     * @param string $code
     * @param string $iCode
     * @param bool $searchMore
     * @param int $order
     */
    public function __construct(\StructType\JP_TransferInfo $transferInfo = null, \ArrayType\ArrayOfJP_TransferOption $transferOptions = null, \StructType\JP_TransferBookingInfo $transferBookingInfo = null, \ArrayType\ArrayOfJP_Origin $origins = null, \ArrayType\ArrayOfJP_Destination $destinations = null, $code = null, $iCode = null, $searchMore = null, $order = null)
    {
        $this
            ->setTransferInfo($transferInfo)
            ->setTransferOptions($transferOptions)
            ->setTransferBookingInfo($transferBookingInfo)
            ->setOrigins($origins)
            ->setDestinations($destinations)
            ->setCode($code)
            ->setICode($iCode)
            ->setSearchMore($searchMore)
            ->setOrder($order);
    }
    /**
     * Get TransferInfo value
     * @return \StructType\JP_TransferInfo|null
     */
    public function getTransferInfo()
    {
        return $this->TransferInfo;
    }
    /**
     * Set TransferInfo value
     * @param \StructType\JP_TransferInfo $transferInfo
     * @return \StructType\JP_Transfer
     */
    public function setTransferInfo(\StructType\JP_TransferInfo $transferInfo = null)
    {
        $this->TransferInfo = $transferInfo;
        return $this;
    }
    /**
     * Get TransferOptions value
     * @return \ArrayType\ArrayOfJP_TransferOption|null
     */
    public function getTransferOptions()
    {
        return $this->TransferOptions;
    }
    /**
     * Set TransferOptions value
     * @param \ArrayType\ArrayOfJP_TransferOption $transferOptions
     * @return \StructType\JP_Transfer
     */
    public function setTransferOptions(\ArrayType\ArrayOfJP_TransferOption $transferOptions = null)
    {
        $this->TransferOptions = $transferOptions;
        return $this;
    }
    /**
     * Get TransferBookingInfo value
     * @return \StructType\JP_TransferBookingInfo|null
     */
    public function getTransferBookingInfo()
    {
        return $this->TransferBookingInfo;
    }
    /**
     * Set TransferBookingInfo value
     * @param \StructType\JP_TransferBookingInfo $transferBookingInfo
     * @return \StructType\JP_Transfer
     */
    public function setTransferBookingInfo(\StructType\JP_TransferBookingInfo $transferBookingInfo = null)
    {
        $this->TransferBookingInfo = $transferBookingInfo;
        return $this;
    }
    /**
     * Get Origins value
     * @return \ArrayType\ArrayOfJP_Origin|null
     */
    public function getOrigins()
    {
        return $this->Origins;
    }
    /**
     * Set Origins value
     * @param \ArrayType\ArrayOfJP_Origin $origins
     * @return \StructType\JP_Transfer
     */
    public function setOrigins(\ArrayType\ArrayOfJP_Origin $origins = null)
    {
        $this->Origins = $origins;
        return $this;
    }
    /**
     * Get Destinations value
     * @return \ArrayType\ArrayOfJP_Destination|null
     */
    public function getDestinations()
    {
        return $this->Destinations;
    }
    /**
     * Set Destinations value
     * @param \ArrayType\ArrayOfJP_Destination $destinations
     * @return \StructType\JP_Transfer
     */
    public function setDestinations(\ArrayType\ArrayOfJP_Destination $destinations = null)
    {
        $this->Destinations = $destinations;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_Transfer
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get ICode value
     * @return string|null
     */
    public function getICode()
    {
        return $this->ICode;
    }
    /**
     * Set ICode value
     * @param string $iCode
     * @return \StructType\JP_Transfer
     */
    public function setICode($iCode = null)
    {
        // validation for constraint: string
        if (!is_null($iCode) && !is_string($iCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iCode)), __LINE__);
        }
        $this->ICode = $iCode;
        return $this;
    }
    /**
     * Get SearchMore value
     * @return bool|null
     */
    public function getSearchMore()
    {
        return $this->SearchMore;
    }
    /**
     * Set SearchMore value
     * @param bool $searchMore
     * @return \StructType\JP_Transfer
     */
    public function setSearchMore($searchMore = null)
    {
        // validation for constraint: boolean
        if (!is_null($searchMore) && !is_bool($searchMore)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($searchMore)), __LINE__);
        }
        $this->SearchMore = $searchMore;
        return $this;
    }
    /**
     * Get Order value
     * @return int|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param int $order
     * @return \StructType\JP_Transfer
     */
    public function setOrder($order = null)
    {
        // validation for constraint: int
        if (!is_null($order) && !is_numeric($order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($order)), __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_Transfer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
