<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_CruiseFlight StructType
 * @subpackage Structs
 */
class JP_CruiseFlight extends AbstractStructBase
{
    /**
     * The Routes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_CruiseFlightRoute
     */
    public $Routes;
    /**
     * The Prices
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Price
     */
    public $Prices;
    /**
     * The Direction
     * @var string
     */
    public $Direction;
    /**
     * The RatePlanCode
     * @var string
     */
    public $RatePlanCode;
    /**
     * Constructor method for JP_CruiseFlight
     * @uses JP_CruiseFlight::setRoutes()
     * @uses JP_CruiseFlight::setPrices()
     * @uses JP_CruiseFlight::setDirection()
     * @uses JP_CruiseFlight::setRatePlanCode()
     * @param \ArrayType\ArrayOfJP_CruiseFlightRoute $routes
     * @param \ArrayType\ArrayOfJP_Price $prices
     * @param string $direction
     * @param string $ratePlanCode
     */
    public function __construct(\ArrayType\ArrayOfJP_CruiseFlightRoute $routes = null, \ArrayType\ArrayOfJP_Price $prices = null, $direction = null, $ratePlanCode = null)
    {
        $this
            ->setRoutes($routes)
            ->setPrices($prices)
            ->setDirection($direction)
            ->setRatePlanCode($ratePlanCode);
    }
    /**
     * Get Routes value
     * @return \ArrayType\ArrayOfJP_CruiseFlightRoute|null
     */
    public function getRoutes()
    {
        return $this->Routes;
    }
    /**
     * Set Routes value
     * @param \ArrayType\ArrayOfJP_CruiseFlightRoute $routes
     * @return \StructType\JP_CruiseFlight
     */
    public function setRoutes(\ArrayType\ArrayOfJP_CruiseFlightRoute $routes = null)
    {
        $this->Routes = $routes;
        return $this;
    }
    /**
     * Get Prices value
     * @return \ArrayType\ArrayOfJP_Price|null
     */
    public function getPrices()
    {
        return $this->Prices;
    }
    /**
     * Set Prices value
     * @param \ArrayType\ArrayOfJP_Price $prices
     * @return \StructType\JP_CruiseFlight
     */
    public function setPrices(\ArrayType\ArrayOfJP_Price $prices = null)
    {
        $this->Prices = $prices;
        return $this;
    }
    /**
     * Get Direction value
     * @return string|null
     */
    public function getDirection()
    {
        return $this->Direction;
    }
    /**
     * Set Direction value
     * @param string $direction
     * @return \StructType\JP_CruiseFlight
     */
    public function setDirection($direction = null)
    {
        // validation for constraint: string
        if (!is_null($direction) && !is_string($direction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($direction)), __LINE__);
        }
        $this->Direction = $direction;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \StructType\JP_CruiseFlight
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_CruiseFlight
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
