<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJPSOAP_Image ArrayType
 * @subpackage Arrays
 */
class ArrayOfJPSOAP_Image extends AbstractStructArrayBase
{
    /**
     * The Images
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JPSOAP_Image[]
     */
    public $Images;
    /**
     * Constructor method for ArrayOfJPSOAP_Image
     * @uses ArrayOfJPSOAP_Image::setImages()
     * @param \StructType\JPSOAP_Image[] $images
     */
    public function __construct(array $images = array())
    {
        $this
            ->setImages($images);
    }
    /**
     * Get Images value
     * @return \StructType\JPSOAP_Image[]|null
     */
    public function getImages()
    {
        return $this->Images;
    }
    /**
     * Set Images value
     * @throws \InvalidArgumentException
     * @param \StructType\JPSOAP_Image[] $images
     * @return \ArrayType\ArrayOfJPSOAP_Image
     */
    public function setImages(array $images = array())
    {
        foreach ($images as $arrayOfJPSOAP_ImageImagesItem) {
            // validation for constraint: itemType
            if (!$arrayOfJPSOAP_ImageImagesItem instanceof \StructType\JPSOAP_Image) {
                throw new \InvalidArgumentException(sprintf('The Images property can only contain items of \StructType\JPSOAP_Image, "%s" given', is_object($arrayOfJPSOAP_ImageImagesItem) ? get_class($arrayOfJPSOAP_ImageImagesItem) : gettype($arrayOfJPSOAP_ImageImagesItem)), __LINE__);
            }
        }
        $this->Images = $images;
        return $this;
    }
    /**
     * Add item to Images value
     * @throws \InvalidArgumentException
     * @param \StructType\JPSOAP_Image $item
     * @return \ArrayType\ArrayOfJPSOAP_Image
     */
    public function addToImages(\StructType\JPSOAP_Image $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JPSOAP_Image) {
            throw new \InvalidArgumentException(sprintf('The Images property can only contain items of \StructType\JPSOAP_Image, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Images[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JPSOAP_Image|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JPSOAP_Image|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JPSOAP_Image|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JPSOAP_Image|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JPSOAP_Image|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Images
     */
    public function getAttributeName()
    {
        return 'Images';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJPSOAP_Image
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
