<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_Flight ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_Flight extends AbstractStructArrayBase
{
    /**
     * The Flight
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_Flight[]
     */
    public $Flight;
    /**
     * Constructor method for ArrayOfJP_Flight
     * @uses ArrayOfJP_Flight::setFlight()
     * @param \StructType\JP_Flight[] $flight
     */
    public function __construct(array $flight = array())
    {
        $this
            ->setFlight($flight);
    }
    /**
     * Get Flight value
     * @return \StructType\JP_Flight[]|null
     */
    public function getFlight()
    {
        return $this->Flight;
    }
    /**
     * Set Flight value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Flight[] $flight
     * @return \ArrayType\ArrayOfJP_Flight
     */
    public function setFlight(array $flight = array())
    {
        foreach ($flight as $arrayOfJP_FlightFlightItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_FlightFlightItem instanceof \StructType\JP_Flight) {
                throw new \InvalidArgumentException(sprintf('The Flight property can only contain items of \StructType\JP_Flight, "%s" given', is_object($arrayOfJP_FlightFlightItem) ? get_class($arrayOfJP_FlightFlightItem) : gettype($arrayOfJP_FlightFlightItem)), __LINE__);
            }
        }
        $this->Flight = $flight;
        return $this;
    }
    /**
     * Add item to Flight value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Flight $item
     * @return \ArrayType\ArrayOfJP_Flight
     */
    public function addToFlight(\StructType\JP_Flight $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_Flight) {
            throw new \InvalidArgumentException(sprintf('The Flight property can only contain items of \StructType\JP_Flight, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Flight[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_Flight|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_Flight|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_Flight|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_Flight|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_Flight|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Flight
     */
    public function getAttributeName()
    {
        return 'Flight';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_Flight
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
