<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_ServiceContract StructType
 * @subpackage Structs
 */
class JP_ServiceContract extends JP_Contract
{
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The ProvCode
     * @var int
     */
    public $ProvCode;
    /**
     * Constructor method for JP_ServiceContract
     * @uses JP_ServiceContract::setName()
     * @uses JP_ServiceContract::setProvCode()
     * @param string $name
     * @param int $provCode
     */
    public function __construct($name = null, $provCode = null)
    {
        $this
            ->setName($name)
            ->setProvCode($provCode);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\JP_ServiceContract
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get ProvCode value
     * @return int|null
     */
    public function getProvCode()
    {
        return $this->ProvCode;
    }
    /**
     * Set ProvCode value
     * @param int $provCode
     * @return \StructType\JP_ServiceContract
     */
    public function setProvCode($provCode = null)
    {
        // validation for constraint: int
        if (!is_null($provCode) && !is_numeric($provCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($provCode)), __LINE__);
        }
        $this->ProvCode = $provCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_ServiceContract
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
