<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_TransportDiscount StructType
 * @subpackage Structs
 */
class JP_TransportDiscount extends AbstractStructBase
{
    /**
     * The Resident
     * @var bool
     */
    public $Resident;
    /**
     * The LargeFamily
     * @var string
     */
    public $LargeFamily;
    /**
     * Constructor method for JP_TransportDiscount
     * @uses JP_TransportDiscount::setResident()
     * @uses JP_TransportDiscount::setLargeFamily()
     * @param bool $resident
     * @param string $largeFamily
     */
    public function __construct($resident = null, $largeFamily = null)
    {
        $this
            ->setResident($resident)
            ->setLargeFamily($largeFamily);
    }
    /**
     * Get Resident value
     * @return bool|null
     */
    public function getResident()
    {
        return $this->Resident;
    }
    /**
     * Set Resident value
     * @param bool $resident
     * @return \StructType\JP_TransportDiscount
     */
    public function setResident($resident = null)
    {
        // validation for constraint: boolean
        if (!is_null($resident) && !is_bool($resident)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($resident, true), gettype($resident)), __LINE__);
        }
        $this->Resident = $resident;
        return $this;
    }
    /**
     * Get LargeFamily value
     * @return string|null
     */
    public function getLargeFamily()
    {
        return $this->LargeFamily;
    }
    /**
     * Set LargeFamily value
     * @param string $largeFamily
     * @return \StructType\JP_TransportDiscount
     */
    public function setLargeFamily($largeFamily = null)
    {
        // validation for constraint: string
        if (!is_null($largeFamily) && !is_string($largeFamily)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($largeFamily, true), gettype($largeFamily)), __LINE__);
        }
        $this->LargeFamily = $largeFamily;
        return $this;
    }
}
