<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_CancelAdvancedOptions StructType
 * @subpackage Structs
 */
class JP_CancelAdvancedOptions extends JP_BaseAdvancedOptions
{
    /**
     * The SendMailTo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SendMailTo;
    /**
     * The ShowBreakdownPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ShowBreakdownPrice;
    /**
     * The ShowCancelBreakdown
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ShowCancelBreakdown;
    /**
     * Constructor method for JP_CancelAdvancedOptions
     * @uses JP_CancelAdvancedOptions::setSendMailTo()
     * @uses JP_CancelAdvancedOptions::setShowBreakdownPrice()
     * @uses JP_CancelAdvancedOptions::setShowCancelBreakdown()
     * @param string $sendMailTo
     * @param bool $showBreakdownPrice
     * @param bool $showCancelBreakdown
     */
    public function __construct($sendMailTo = null, $showBreakdownPrice = null, $showCancelBreakdown = null)
    {
        $this
            ->setSendMailTo($sendMailTo)
            ->setShowBreakdownPrice($showBreakdownPrice)
            ->setShowCancelBreakdown($showCancelBreakdown);
    }
    /**
     * Get SendMailTo value
     * @return string|null
     */
    public function getSendMailTo()
    {
        return $this->SendMailTo;
    }
    /**
     * Set SendMailTo value
     * @uses \EnumType\JP_SendMailTo::valueIsValid()
     * @uses \EnumType\JP_SendMailTo::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sendMailTo
     * @return \StructType\JP_CancelAdvancedOptions
     */
    public function setSendMailTo($sendMailTo = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_SendMailTo::valueIsValid($sendMailTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JP_SendMailTo', is_array($sendMailTo) ? implode(', ', $sendMailTo) : var_export($sendMailTo, true), implode(', ', \EnumType\JP_SendMailTo::getValidValues())), __LINE__);
        }
        $this->SendMailTo = $sendMailTo;
        return $this;
    }
    /**
     * Get ShowBreakdownPrice value
     * @return bool|null
     */
    public function getShowBreakdownPrice()
    {
        return $this->ShowBreakdownPrice;
    }
    /**
     * Set ShowBreakdownPrice value
     * @param bool $showBreakdownPrice
     * @return \StructType\JP_CancelAdvancedOptions
     */
    public function setShowBreakdownPrice($showBreakdownPrice = null)
    {
        // validation for constraint: boolean
        if (!is_null($showBreakdownPrice) && !is_bool($showBreakdownPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showBreakdownPrice, true), gettype($showBreakdownPrice)), __LINE__);
        }
        $this->ShowBreakdownPrice = $showBreakdownPrice;
        return $this;
    }
    /**
     * Get ShowCancelBreakdown value
     * @return bool|null
     */
    public function getShowCancelBreakdown()
    {
        return $this->ShowCancelBreakdown;
    }
    /**
     * Set ShowCancelBreakdown value
     * @param bool $showCancelBreakdown
     * @return \StructType\JP_CancelAdvancedOptions
     */
    public function setShowCancelBreakdown($showCancelBreakdown = null)
    {
        // validation for constraint: boolean
        if (!is_null($showCancelBreakdown) && !is_bool($showCancelBreakdown)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showCancelBreakdown, true), gettype($showCancelBreakdown)), __LINE__);
        }
        $this->ShowCancelBreakdown = $showCancelBreakdown;
        return $this;
    }
}
