<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_InfoExtra StructType
 * @subpackage Structs
 */
class JP_InfoExtra extends AbstractStructBase
{
    /**
     * The Origin
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Origin;
    /**
     * The Destination
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Destination;
    /**
     * The ExternalLocator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExternalLocator;
    /**
     * The Source
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Source;
    /**
     * Constructor method for JP_InfoExtra
     * @uses JP_InfoExtra::setOrigin()
     * @uses JP_InfoExtra::setDestination()
     * @uses JP_InfoExtra::setExternalLocator()
     * @uses JP_InfoExtra::setSource()
     * @param int $origin
     * @param int $destination
     * @param string $externalLocator
     * @param string $source
     */
    public function __construct($origin = null, $destination = null, $externalLocator = null, $source = null)
    {
        $this
            ->setOrigin($origin)
            ->setDestination($destination)
            ->setExternalLocator($externalLocator)
            ->setSource($source);
    }
    /**
     * Get Origin value
     * @return int
     */
    public function getOrigin()
    {
        return $this->Origin;
    }
    /**
     * Set Origin value
     * @param int $origin
     * @return \StructType\JP_InfoExtra
     */
    public function setOrigin($origin = null)
    {
        // validation for constraint: int
        if (!is_null($origin) && !(is_int($origin) || ctype_digit($origin))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($origin, true), gettype($origin)), __LINE__);
        }
        $this->Origin = $origin;
        return $this;
    }
    /**
     * Get Destination value
     * @return int
     */
    public function getDestination()
    {
        return $this->Destination;
    }
    /**
     * Set Destination value
     * @param int $destination
     * @return \StructType\JP_InfoExtra
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: int
        if (!is_null($destination) && !(is_int($destination) || ctype_digit($destination))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($destination, true), gettype($destination)), __LINE__);
        }
        $this->Destination = $destination;
        return $this;
    }
    /**
     * Get ExternalLocator value
     * @return string|null
     */
    public function getExternalLocator()
    {
        return $this->ExternalLocator;
    }
    /**
     * Set ExternalLocator value
     * @param string $externalLocator
     * @return \StructType\JP_InfoExtra
     */
    public function setExternalLocator($externalLocator = null)
    {
        // validation for constraint: string
        if (!is_null($externalLocator) && !is_string($externalLocator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalLocator, true), gettype($externalLocator)), __LINE__);
        }
        $this->ExternalLocator = $externalLocator;
        return $this;
    }
    /**
     * Get Source value
     * @return string|null
     */
    public function getSource()
    {
        return $this->Source;
    }
    /**
     * Set Source value
     * @param string $source
     * @return \StructType\JP_InfoExtra
     */
    public function setSource($source = null)
    {
        // validation for constraint: string
        if (!is_null($source) && !is_string($source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($source, true), gettype($source)), __LINE__);
        }
        $this->Source = $source;
        return $this;
    }
}
