<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_CommonPriceBreakdownReduced StructType
 * @subpackage Structs
 */
class JP_CommonPriceBreakdownReduced extends AbstractStructBase
{
    /**
     * The Base
     * @var float
     */
    public $Base;
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * The Percentage
     * @var float
     */
    public $Percentage;
    /**
     * Constructor method for JP_CommonPriceBreakdownReduced
     * @uses JP_CommonPriceBreakdownReduced::setBase()
     * @uses JP_CommonPriceBreakdownReduced::setAmount()
     * @uses JP_CommonPriceBreakdownReduced::setPercentage()
     * @param float $base
     * @param float $amount
     * @param float $percentage
     */
    public function __construct($base = null, $amount = null, $percentage = null)
    {
        $this
            ->setBase($base)
            ->setAmount($amount)
            ->setPercentage($percentage);
    }
    /**
     * Get Base value
     * @return float|null
     */
    public function getBase()
    {
        return $this->Base;
    }
    /**
     * Set Base value
     * @param float $base
     * @return \StructType\JP_CommonPriceBreakdownReduced
     */
    public function setBase($base = null)
    {
        // validation for constraint: float
        if (!is_null($base) && !(is_float($base) || is_numeric($base))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($base, true), gettype($base)), __LINE__);
        }
        $this->Base = $base;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\JP_CommonPriceBreakdownReduced
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Percentage value
     * @return float|null
     */
    public function getPercentage()
    {
        return $this->Percentage;
    }
    /**
     * Set Percentage value
     * @param float $percentage
     * @return \StructType\JP_CommonPriceBreakdownReduced
     */
    public function setPercentage($percentage = null)
    {
        // validation for constraint: float
        if (!is_null($percentage) && !(is_float($percentage) || is_numeric($percentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percentage, true), gettype($percentage)), __LINE__);
        }
        $this->Percentage = $percentage;
        return $this;
    }
}
