<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_AdjustmentItem StructType
 * @subpackage Structs
 */
class JP_AdjustmentItem extends JP_BaseItem
{
    /**
     * The Start
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Start;
    /**
     * The End
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $End;
    /**
     * The AdjustmentInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_ItemAdjustmentInfo
     */
    public $AdjustmentInfo;
    /**
     * Constructor method for JP_AdjustmentItem
     * @uses JP_AdjustmentItem::setStart()
     * @uses JP_AdjustmentItem::setEnd()
     * @uses JP_AdjustmentItem::setAdjustmentInfo()
     * @param string $start
     * @param string $end
     * @param \StructType\JP_ItemAdjustmentInfo $adjustmentInfo
     */
    public function __construct($start = null, $end = null, \StructType\JP_ItemAdjustmentInfo $adjustmentInfo = null)
    {
        $this
            ->setStart($start)
            ->setEnd($end)
            ->setAdjustmentInfo($adjustmentInfo);
    }
    /**
     * Get Start value
     * @return string
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\JP_AdjustmentItem
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get End value
     * @return string
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\JP_AdjustmentItem
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get AdjustmentInfo value
     * @return \StructType\JP_ItemAdjustmentInfo|null
     */
    public function getAdjustmentInfo()
    {
        return $this->AdjustmentInfo;
    }
    /**
     * Set AdjustmentInfo value
     * @param \StructType\JP_ItemAdjustmentInfo $adjustmentInfo
     * @return \StructType\JP_AdjustmentItem
     */
    public function setAdjustmentInfo(\StructType\JP_ItemAdjustmentInfo $adjustmentInfo = null)
    {
        $this->AdjustmentInfo = $adjustmentInfo;
        return $this;
    }
}
