<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfString7 ArrayType
 * @subpackage Arrays
 */
class ArrayOfString7 extends AbstractStructArrayBase
{
    /**
     * The ServiceCode
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $ServiceCode;
    /**
     * Constructor method for ArrayOfString7
     * @uses ArrayOfString7::setServiceCode()
     * @param string[] $serviceCode
     */
    public function __construct(array $serviceCode = array())
    {
        $this
            ->setServiceCode($serviceCode);
    }
    /**
     * Get ServiceCode value
     * @return string[]|null
     */
    public function getServiceCode()
    {
        return $this->ServiceCode;
    }
    /**
     * This method is responsible for validating the values passed to the setServiceCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setServiceCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateServiceCodeForArrayConstraintsFromSetServiceCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfString7ServiceCodeItem) {
            // validation for constraint: itemType
            if (!is_string($arrayOfString7ServiceCodeItem)) {
                $invalidValues[] = is_object($arrayOfString7ServiceCodeItem) ? get_class($arrayOfString7ServiceCodeItem) : sprintf('%s(%s)', gettype($arrayOfString7ServiceCodeItem), var_export($arrayOfString7ServiceCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ServiceCode property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ServiceCode value
     * @throws \InvalidArgumentException
     * @param string[] $serviceCode
     * @return \ArrayType\ArrayOfString7
     */
    public function setServiceCode(array $serviceCode = array())
    {
        // validation for constraint: array
        if ('' !== ($serviceCodeArrayErrorMessage = self::validateServiceCodeForArrayConstraintsFromSetServiceCode($serviceCode))) {
            throw new \InvalidArgumentException($serviceCodeArrayErrorMessage, __LINE__);
        }
        $this->ServiceCode = $serviceCode;
        return $this;
    }
    /**
     * Add item to ServiceCode value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ArrayType\ArrayOfString7
     */
    public function addToServiceCode($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The ServiceCode property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ServiceCode[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ServiceCode
     */
    public function getAttributeName()
    {
        return 'ServiceCode';
    }
}
