<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Agency ServiceType
 * @subpackage Services
 */
class Agency extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AgencyRead
     * Meta informations extracted from the WSDL
     * - documentation: Generic Agency List
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AgencyRead $parameters
     * @return \StructType\AgencyReadResponse|bool
     */
    public function AgencyRead(\StructType\AgencyRead $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AgencyRead($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AgencyReadResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
