<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_ServiceSimpleInfo StructType
 * @subpackage Structs
 */
class JP_ServiceSimpleInfo extends AbstractStructBase
{
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Options
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_ServiceOption
     */
    public $Options;
    /**
     * The Zones
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Zone
     */
    public $Zones;
    /**
     * The Origins
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Origin
     */
    public $Origins;
    /**
     * The Destinations
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Destination
     */
    public $Destinations;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * Constructor method for JP_ServiceSimpleInfo
     * @uses JP_ServiceSimpleInfo::setName()
     * @uses JP_ServiceSimpleInfo::setOptions()
     * @uses JP_ServiceSimpleInfo::setZones()
     * @uses JP_ServiceSimpleInfo::setOrigins()
     * @uses JP_ServiceSimpleInfo::setDestinations()
     * @uses JP_ServiceSimpleInfo::setCode()
     * @param string $name
     * @param \ArrayType\ArrayOfJP_ServiceOption $options
     * @param \ArrayType\ArrayOfJP_Zone $zones
     * @param \ArrayType\ArrayOfJP_Origin $origins
     * @param \ArrayType\ArrayOfJP_Destination $destinations
     * @param string $code
     */
    public function __construct($name = null, \ArrayType\ArrayOfJP_ServiceOption $options = null, \ArrayType\ArrayOfJP_Zone $zones = null, \ArrayType\ArrayOfJP_Origin $origins = null, \ArrayType\ArrayOfJP_Destination $destinations = null, $code = null)
    {
        $this
            ->setName($name)
            ->setOptions($options)
            ->setZones($zones)
            ->setOrigins($origins)
            ->setDestinations($destinations)
            ->setCode($code);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\JP_ServiceSimpleInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Options value
     * @return \ArrayType\ArrayOfJP_ServiceOption|null
     */
    public function getOptions()
    {
        return $this->Options;
    }
    /**
     * Set Options value
     * @param \ArrayType\ArrayOfJP_ServiceOption $options
     * @return \StructType\JP_ServiceSimpleInfo
     */
    public function setOptions(\ArrayType\ArrayOfJP_ServiceOption $options = null)
    {
        $this->Options = $options;
        return $this;
    }
    /**
     * Get Zones value
     * @return \ArrayType\ArrayOfJP_Zone|null
     */
    public function getZones()
    {
        return $this->Zones;
    }
    /**
     * Set Zones value
     * @param \ArrayType\ArrayOfJP_Zone $zones
     * @return \StructType\JP_ServiceSimpleInfo
     */
    public function setZones(\ArrayType\ArrayOfJP_Zone $zones = null)
    {
        $this->Zones = $zones;
        return $this;
    }
    /**
     * Get Origins value
     * @return \ArrayType\ArrayOfJP_Origin|null
     */
    public function getOrigins()
    {
        return $this->Origins;
    }
    /**
     * Set Origins value
     * @param \ArrayType\ArrayOfJP_Origin $origins
     * @return \StructType\JP_ServiceSimpleInfo
     */
    public function setOrigins(\ArrayType\ArrayOfJP_Origin $origins = null)
    {
        $this->Origins = $origins;
        return $this;
    }
    /**
     * Get Destinations value
     * @return \ArrayType\ArrayOfJP_Destination|null
     */
    public function getDestinations()
    {
        return $this->Destinations;
    }
    /**
     * Set Destinations value
     * @param \ArrayType\ArrayOfJP_Destination $destinations
     * @return \StructType\JP_ServiceSimpleInfo
     */
    public function setDestinations(\ArrayType\ArrayOfJP_Destination $destinations = null)
    {
        $this->Destinations = $destinations;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_ServiceSimpleInfo
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_ServiceSimpleInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
