<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_RoomList StructType
 * @subpackage Structs
 */
class JP_RoomList extends AbstractStructBase
{
    /**
     * The TotalRecords
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $TotalRecords;
    /**
     * The Room
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_RoomInfo[]
     */
    public $Room;
    /**
     * Constructor method for JP_RoomList
     * @uses JP_RoomList::setTotalRecords()
     * @uses JP_RoomList::setRoom()
     * @param int $totalRecords
     * @param \StructType\JP_RoomInfo[] $room
     */
    public function __construct($totalRecords = null, array $room = array())
    {
        $this
            ->setTotalRecords($totalRecords)
            ->setRoom($room);
    }
    /**
     * Get TotalRecords value
     * @return int
     */
    public function getTotalRecords()
    {
        return $this->TotalRecords;
    }
    /**
     * Set TotalRecords value
     * @param int $totalRecords
     * @return \StructType\JP_RoomList
     */
    public function setTotalRecords($totalRecords = null)
    {
        // validation for constraint: int
        if (!is_null($totalRecords) && !is_numeric($totalRecords)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totalRecords)), __LINE__);
        }
        $this->TotalRecords = $totalRecords;
        return $this;
    }
    /**
     * Get Room value
     * @return \StructType\JP_RoomInfo[]|null
     */
    public function getRoom()
    {
        return $this->Room;
    }
    /**
     * Set Room value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_RoomInfo[] $room
     * @return \StructType\JP_RoomList
     */
    public function setRoom(array $room = array())
    {
        foreach ($room as $jP_RoomListRoomItem) {
            // validation for constraint: itemType
            if (!$jP_RoomListRoomItem instanceof \StructType\JP_RoomInfo) {
                throw new \InvalidArgumentException(sprintf('The Room property can only contain items of \StructType\JP_RoomInfo, "%s" given', is_object($jP_RoomListRoomItem) ? get_class($jP_RoomListRoomItem) : gettype($jP_RoomListRoomItem)), __LINE__);
            }
        }
        $this->Room = $room;
        return $this;
    }
    /**
     * Add item to Room value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_RoomInfo $item
     * @return \StructType\JP_RoomList
     */
    public function addToRoom(\StructType\JP_RoomInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_RoomInfo) {
            throw new \InvalidArgumentException(sprintf('The Room property can only contain items of \StructType\JP_RoomInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Room[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_RoomList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
