<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_InsuranceItem StructType
 * @subpackage Structs
 */
class JP_InsuranceItem extends JP_BaseItem
{
    /**
     * The InsuranceInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_InsuranceInfo
     */
    public $InsuranceInfo;
    /**
     * The RelPaxes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_RelPax
     */
    public $RelPaxes;
    /**
     * The Start
     * @var string
     */
    public $Start;
    /**
     * The End
     * @var string
     */
    public $End;
    /**
     * Constructor method for JP_InsuranceItem
     * @uses JP_InsuranceItem::setInsuranceInfo()
     * @uses JP_InsuranceItem::setRelPaxes()
     * @uses JP_InsuranceItem::setStart()
     * @uses JP_InsuranceItem::setEnd()
     * @param \StructType\JP_InsuranceInfo $insuranceInfo
     * @param \ArrayType\ArrayOfJP_RelPax $relPaxes
     * @param string $start
     * @param string $end
     */
    public function __construct(\StructType\JP_InsuranceInfo $insuranceInfo = null, \ArrayType\ArrayOfJP_RelPax $relPaxes = null, $start = null, $end = null)
    {
        $this
            ->setInsuranceInfo($insuranceInfo)
            ->setRelPaxes($relPaxes)
            ->setStart($start)
            ->setEnd($end);
    }
    /**
     * Get InsuranceInfo value
     * @return \StructType\JP_InsuranceInfo|null
     */
    public function getInsuranceInfo()
    {
        return $this->InsuranceInfo;
    }
    /**
     * Set InsuranceInfo value
     * @param \StructType\JP_InsuranceInfo $insuranceInfo
     * @return \StructType\JP_InsuranceItem
     */
    public function setInsuranceInfo(\StructType\JP_InsuranceInfo $insuranceInfo = null)
    {
        $this->InsuranceInfo = $insuranceInfo;
        return $this;
    }
    /**
     * Get RelPaxes value
     * @return \ArrayType\ArrayOfJP_RelPax|null
     */
    public function getRelPaxes()
    {
        return $this->RelPaxes;
    }
    /**
     * Set RelPaxes value
     * @param \ArrayType\ArrayOfJP_RelPax $relPaxes
     * @return \StructType\JP_InsuranceItem
     */
    public function setRelPaxes(\ArrayType\ArrayOfJP_RelPax $relPaxes = null)
    {
        $this->RelPaxes = $relPaxes;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\JP_InsuranceItem
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\JP_InsuranceItem
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_InsuranceItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
