<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_HotelModify StructType
 * @subpackage Structs
 */
class JP_HotelModify extends AbstractStructBase
{
    /**
     * The Login
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Login
     */
    public $Login;
    /**
     * The ReservationLocator
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_ReservationLocationModify
     */
    public $ReservationLocator;
    /**
     * The Paxes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Paxes
     */
    public $Paxes;
    /**
     * The Holder
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Holder
     */
    public $Holder;
    /**
     * The ExternalBookingReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExternalBookingReference;
    /**
     * The Comments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Comment
     */
    public $Comments;
    /**
     * The SearchSementHotels
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_SearchSegmentHotelsModify
     */
    public $SearchSementHotels;
    /**
     * The RelPaxesDist
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_HotelRelPaxDist
     */
    public $RelPaxesDist;
    /**
     * The AdvancedOptions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_HotelModifyAdvancedOptions
     */
    public $AdvancedOptions;
    /**
     * The RestrictedOptions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_RestrictedOptions
     */
    public $RestrictedOptions;
    /**
     * The Version
     * @var string
     */
    public $Version;
    /**
     * The Language
     * @var string
     */
    public $Language;
    /**
     * Constructor method for JP_HotelModify
     * @uses JP_HotelModify::setLogin()
     * @uses JP_HotelModify::setReservationLocator()
     * @uses JP_HotelModify::setPaxes()
     * @uses JP_HotelModify::setHolder()
     * @uses JP_HotelModify::setExternalBookingReference()
     * @uses JP_HotelModify::setComments()
     * @uses JP_HotelModify::setSearchSementHotels()
     * @uses JP_HotelModify::setRelPaxesDist()
     * @uses JP_HotelModify::setAdvancedOptions()
     * @uses JP_HotelModify::setRestrictedOptions()
     * @uses JP_HotelModify::setVersion()
     * @uses JP_HotelModify::setLanguage()
     * @param \StructType\JP_Login $login
     * @param \StructType\JP_ReservationLocationModify $reservationLocator
     * @param \StructType\JP_Paxes $paxes
     * @param \StructType\JP_Holder $holder
     * @param string $externalBookingReference
     * @param \ArrayType\ArrayOfJP_Comment $comments
     * @param \StructType\JP_SearchSegmentHotelsModify $searchSementHotels
     * @param \ArrayType\ArrayOfJP_HotelRelPaxDist $relPaxesDist
     * @param \StructType\JP_HotelModifyAdvancedOptions $advancedOptions
     * @param \StructType\JP_RestrictedOptions $restrictedOptions
     * @param string $version
     * @param string $language
     */
    public function __construct(\StructType\JP_Login $login = null, \StructType\JP_ReservationLocationModify $reservationLocator = null, \StructType\JP_Paxes $paxes = null, \StructType\JP_Holder $holder = null, $externalBookingReference = null, \ArrayType\ArrayOfJP_Comment $comments = null, \StructType\JP_SearchSegmentHotelsModify $searchSementHotels = null, \ArrayType\ArrayOfJP_HotelRelPaxDist $relPaxesDist = null, \StructType\JP_HotelModifyAdvancedOptions $advancedOptions = null, \StructType\JP_RestrictedOptions $restrictedOptions = null, $version = null, $language = null)
    {
        $this
            ->setLogin($login)
            ->setReservationLocator($reservationLocator)
            ->setPaxes($paxes)
            ->setHolder($holder)
            ->setExternalBookingReference($externalBookingReference)
            ->setComments($comments)
            ->setSearchSementHotels($searchSementHotels)
            ->setRelPaxesDist($relPaxesDist)
            ->setAdvancedOptions($advancedOptions)
            ->setRestrictedOptions($restrictedOptions)
            ->setVersion($version)
            ->setLanguage($language);
    }
    /**
     * Get Login value
     * @return \StructType\JP_Login|null
     */
    public function getLogin()
    {
        return $this->Login;
    }
    /**
     * Set Login value
     * @param \StructType\JP_Login $login
     * @return \StructType\JP_HotelModify
     */
    public function setLogin(\StructType\JP_Login $login = null)
    {
        $this->Login = $login;
        return $this;
    }
    /**
     * Get ReservationLocator value
     * @return \StructType\JP_ReservationLocationModify|null
     */
    public function getReservationLocator()
    {
        return $this->ReservationLocator;
    }
    /**
     * Set ReservationLocator value
     * @param \StructType\JP_ReservationLocationModify $reservationLocator
     * @return \StructType\JP_HotelModify
     */
    public function setReservationLocator(\StructType\JP_ReservationLocationModify $reservationLocator = null)
    {
        $this->ReservationLocator = $reservationLocator;
        return $this;
    }
    /**
     * Get Paxes value
     * @return \StructType\JP_Paxes|null
     */
    public function getPaxes()
    {
        return $this->Paxes;
    }
    /**
     * Set Paxes value
     * @param \StructType\JP_Paxes $paxes
     * @return \StructType\JP_HotelModify
     */
    public function setPaxes(\StructType\JP_Paxes $paxes = null)
    {
        $this->Paxes = $paxes;
        return $this;
    }
    /**
     * Get Holder value
     * @return \StructType\JP_Holder|null
     */
    public function getHolder()
    {
        return $this->Holder;
    }
    /**
     * Set Holder value
     * @param \StructType\JP_Holder $holder
     * @return \StructType\JP_HotelModify
     */
    public function setHolder(\StructType\JP_Holder $holder = null)
    {
        $this->Holder = $holder;
        return $this;
    }
    /**
     * Get ExternalBookingReference value
     * @return string|null
     */
    public function getExternalBookingReference()
    {
        return $this->ExternalBookingReference;
    }
    /**
     * Set ExternalBookingReference value
     * @param string $externalBookingReference
     * @return \StructType\JP_HotelModify
     */
    public function setExternalBookingReference($externalBookingReference = null)
    {
        // validation for constraint: string
        if (!is_null($externalBookingReference) && !is_string($externalBookingReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalBookingReference)), __LINE__);
        }
        $this->ExternalBookingReference = $externalBookingReference;
        return $this;
    }
    /**
     * Get Comments value
     * @return \ArrayType\ArrayOfJP_Comment|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param \ArrayType\ArrayOfJP_Comment $comments
     * @return \StructType\JP_HotelModify
     */
    public function setComments(\ArrayType\ArrayOfJP_Comment $comments = null)
    {
        $this->Comments = $comments;
        return $this;
    }
    /**
     * Get SearchSementHotels value
     * @return \StructType\JP_SearchSegmentHotelsModify|null
     */
    public function getSearchSementHotels()
    {
        return $this->SearchSementHotels;
    }
    /**
     * Set SearchSementHotels value
     * @param \StructType\JP_SearchSegmentHotelsModify $searchSementHotels
     * @return \StructType\JP_HotelModify
     */
    public function setSearchSementHotels(\StructType\JP_SearchSegmentHotelsModify $searchSementHotels = null)
    {
        $this->SearchSementHotels = $searchSementHotels;
        return $this;
    }
    /**
     * Get RelPaxesDist value
     * @return \ArrayType\ArrayOfJP_HotelRelPaxDist|null
     */
    public function getRelPaxesDist()
    {
        return $this->RelPaxesDist;
    }
    /**
     * Set RelPaxesDist value
     * @param \ArrayType\ArrayOfJP_HotelRelPaxDist $relPaxesDist
     * @return \StructType\JP_HotelModify
     */
    public function setRelPaxesDist(\ArrayType\ArrayOfJP_HotelRelPaxDist $relPaxesDist = null)
    {
        $this->RelPaxesDist = $relPaxesDist;
        return $this;
    }
    /**
     * Get AdvancedOptions value
     * @return \StructType\JP_HotelModifyAdvancedOptions|null
     */
    public function getAdvancedOptions()
    {
        return $this->AdvancedOptions;
    }
    /**
     * Set AdvancedOptions value
     * @param \StructType\JP_HotelModifyAdvancedOptions $advancedOptions
     * @return \StructType\JP_HotelModify
     */
    public function setAdvancedOptions(\StructType\JP_HotelModifyAdvancedOptions $advancedOptions = null)
    {
        $this->AdvancedOptions = $advancedOptions;
        return $this;
    }
    /**
     * Get RestrictedOptions value
     * @return \StructType\JP_RestrictedOptions|null
     */
    public function getRestrictedOptions()
    {
        return $this->RestrictedOptions;
    }
    /**
     * Set RestrictedOptions value
     * @param \StructType\JP_RestrictedOptions $restrictedOptions
     * @return \StructType\JP_HotelModify
     */
    public function setRestrictedOptions(\StructType\JP_RestrictedOptions $restrictedOptions = null)
    {
        $this->RestrictedOptions = $restrictedOptions;
        return $this;
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \StructType\JP_HotelModify
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\JP_HotelModify
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_HotelModify
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
