<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_TransferContent StructType
 * @subpackage Structs
 */
class JP_TransferContent extends AbstractStructBase
{
    /**
     * The TransferContentInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_TransferContentInfo
     */
    public $TransferContentInfo;
    /**
     * The TransferZones
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_TransferZones
     */
    public $TransferZones;
    /**
     * The TransferOptions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_TransferContentOption
     */
    public $TransferOptions;
    /**
     * The TransferType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_TransferType
     */
    public $TransferType;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The Order
     * @var int
     */
    public $Order;
    /**
     * Constructor method for JP_TransferContent
     * @uses JP_TransferContent::setTransferContentInfo()
     * @uses JP_TransferContent::setTransferZones()
     * @uses JP_TransferContent::setTransferOptions()
     * @uses JP_TransferContent::setTransferType()
     * @uses JP_TransferContent::setCode()
     * @uses JP_TransferContent::setOrder()
     * @param \StructType\JP_TransferContentInfo $transferContentInfo
     * @param \StructType\JP_TransferZones $transferZones
     * @param \ArrayType\ArrayOfJP_TransferContentOption $transferOptions
     * @param \StructType\JP_TransferType $transferType
     * @param string $code
     * @param int $order
     */
    public function __construct(\StructType\JP_TransferContentInfo $transferContentInfo = null, \StructType\JP_TransferZones $transferZones = null, \ArrayType\ArrayOfJP_TransferContentOption $transferOptions = null, \StructType\JP_TransferType $transferType = null, $code = null, $order = null)
    {
        $this
            ->setTransferContentInfo($transferContentInfo)
            ->setTransferZones($transferZones)
            ->setTransferOptions($transferOptions)
            ->setTransferType($transferType)
            ->setCode($code)
            ->setOrder($order);
    }
    /**
     * Get TransferContentInfo value
     * @return \StructType\JP_TransferContentInfo|null
     */
    public function getTransferContentInfo()
    {
        return $this->TransferContentInfo;
    }
    /**
     * Set TransferContentInfo value
     * @param \StructType\JP_TransferContentInfo $transferContentInfo
     * @return \StructType\JP_TransferContent
     */
    public function setTransferContentInfo(\StructType\JP_TransferContentInfo $transferContentInfo = null)
    {
        $this->TransferContentInfo = $transferContentInfo;
        return $this;
    }
    /**
     * Get TransferZones value
     * @return \StructType\JP_TransferZones|null
     */
    public function getTransferZones()
    {
        return $this->TransferZones;
    }
    /**
     * Set TransferZones value
     * @param \StructType\JP_TransferZones $transferZones
     * @return \StructType\JP_TransferContent
     */
    public function setTransferZones(\StructType\JP_TransferZones $transferZones = null)
    {
        $this->TransferZones = $transferZones;
        return $this;
    }
    /**
     * Get TransferOptions value
     * @return \ArrayType\ArrayOfJP_TransferContentOption|null
     */
    public function getTransferOptions()
    {
        return $this->TransferOptions;
    }
    /**
     * Set TransferOptions value
     * @param \ArrayType\ArrayOfJP_TransferContentOption $transferOptions
     * @return \StructType\JP_TransferContent
     */
    public function setTransferOptions(\ArrayType\ArrayOfJP_TransferContentOption $transferOptions = null)
    {
        $this->TransferOptions = $transferOptions;
        return $this;
    }
    /**
     * Get TransferType value
     * @return \StructType\JP_TransferType|null
     */
    public function getTransferType()
    {
        return $this->TransferType;
    }
    /**
     * Set TransferType value
     * @param \StructType\JP_TransferType $transferType
     * @return \StructType\JP_TransferContent
     */
    public function setTransferType(\StructType\JP_TransferType $transferType = null)
    {
        $this->TransferType = $transferType;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_TransferContent
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Order value
     * @return int|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param int $order
     * @return \StructType\JP_TransferContent
     */
    public function setOrder($order = null)
    {
        // validation for constraint: int
        if (!is_null($order) && !(is_int($order) || ctype_digit($order))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($order, true), gettype($order)), __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
}
