<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_CreditCard ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_CreditCard extends AbstractStructArrayBase
{
    /**
     * The CreditCard
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_CreditCard[]
     */
    public $CreditCard;
    /**
     * Constructor method for ArrayOfJP_CreditCard
     * @uses ArrayOfJP_CreditCard::setCreditCard()
     * @param \StructType\JP_CreditCard[] $creditCard
     */
    public function __construct(array $creditCard = array())
    {
        $this
            ->setCreditCard($creditCard);
    }
    /**
     * Get CreditCard value
     * @return \StructType\JP_CreditCard[]|null
     */
    public function getCreditCard()
    {
        return $this->CreditCard;
    }
    /**
     * This method is responsible for validating the values passed to the setCreditCard method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCreditCard method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCreditCardForArrayConstraintsFromSetCreditCard(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfJP_CreditCardCreditCardItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_CreditCardCreditCardItem instanceof \StructType\JP_CreditCard) {
                $invalidValues[] = is_object($arrayOfJP_CreditCardCreditCardItem) ? get_class($arrayOfJP_CreditCardCreditCardItem) : sprintf('%s(%s)', gettype($arrayOfJP_CreditCardCreditCardItem), var_export($arrayOfJP_CreditCardCreditCardItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CreditCard property can only contain items of type \StructType\JP_CreditCard, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CreditCard value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_CreditCard[] $creditCard
     * @return \ArrayType\ArrayOfJP_CreditCard
     */
    public function setCreditCard(array $creditCard = array())
    {
        // validation for constraint: array
        if ('' !== ($creditCardArrayErrorMessage = self::validateCreditCardForArrayConstraintsFromSetCreditCard($creditCard))) {
            throw new \InvalidArgumentException($creditCardArrayErrorMessage, __LINE__);
        }
        $this->CreditCard = $creditCard;
        return $this;
    }
    /**
     * Add item to CreditCard value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_CreditCard $item
     * @return \ArrayType\ArrayOfJP_CreditCard
     */
    public function addToCreditCard(\StructType\JP_CreditCard $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_CreditCard) {
            throw new \InvalidArgumentException(sprintf('The CreditCard property can only contain items of type \StructType\JP_CreditCard, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CreditCard[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_CreditCard|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_CreditCard|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_CreditCard|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_CreditCard|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_CreditCard|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CreditCard
     */
    public function getAttributeName()
    {
        return 'CreditCard';
    }
}
