<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_SearchSegmentTransfersByHotel StructType
 * @subpackage Structs
 */
class JP_SearchSegmentTransfersByHotel extends JP_SearchSegmentBase
{
    /**
     * The Suppliers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Suppliers
     */
    public $Suppliers;
    /**
     * The HotelCode
     * @var string
     */
    public $HotelCode;
    /**
     * The Hour
     * @var string
     */
    public $Hour;
    /**
     * The HourEnd
     * @var string
     */
    public $HourEnd;
    /**
     * The Type
     * @var int
     */
    public $Type;
    /**
     * The Route
     * @var string
     */
    public $Route;
    /**
     * The HourType
     * @var string
     */
    public $HourType;
    /**
     * Constructor method for JP_SearchSegmentTransfersByHotel
     * @uses JP_SearchSegmentTransfersByHotel::setSuppliers()
     * @uses JP_SearchSegmentTransfersByHotel::setHotelCode()
     * @uses JP_SearchSegmentTransfersByHotel::setHour()
     * @uses JP_SearchSegmentTransfersByHotel::setHourEnd()
     * @uses JP_SearchSegmentTransfersByHotel::setType()
     * @uses JP_SearchSegmentTransfersByHotel::setRoute()
     * @uses JP_SearchSegmentTransfersByHotel::setHourType()
     * @param \StructType\JP_Suppliers $suppliers
     * @param string $hotelCode
     * @param string $hour
     * @param string $hourEnd
     * @param int $type
     * @param string $route
     * @param string $hourType
     */
    public function __construct(\StructType\JP_Suppliers $suppliers = null, $hotelCode = null, $hour = null, $hourEnd = null, $type = null, $route = null, $hourType = null)
    {
        $this
            ->setSuppliers($suppliers)
            ->setHotelCode($hotelCode)
            ->setHour($hour)
            ->setHourEnd($hourEnd)
            ->setType($type)
            ->setRoute($route)
            ->setHourType($hourType);
    }
    /**
     * Get Suppliers value
     * @return \StructType\JP_Suppliers|null
     */
    public function getSuppliers()
    {
        return $this->Suppliers;
    }
    /**
     * Set Suppliers value
     * @param \StructType\JP_Suppliers $suppliers
     * @return \StructType\JP_SearchSegmentTransfersByHotel
     */
    public function setSuppliers(\StructType\JP_Suppliers $suppliers = null)
    {
        $this->Suppliers = $suppliers;
        return $this;
    }
    /**
     * Get HotelCode value
     * @return string|null
     */
    public function getHotelCode()
    {
        return $this->HotelCode;
    }
    /**
     * Set HotelCode value
     * @param string $hotelCode
     * @return \StructType\JP_SearchSegmentTransfersByHotel
     */
    public function setHotelCode($hotelCode = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCode) && !is_string($hotelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelCode, true), gettype($hotelCode)), __LINE__);
        }
        $this->HotelCode = $hotelCode;
        return $this;
    }
    /**
     * Get Hour value
     * @return string|null
     */
    public function getHour()
    {
        return $this->Hour;
    }
    /**
     * Set Hour value
     * @param string $hour
     * @return \StructType\JP_SearchSegmentTransfersByHotel
     */
    public function setHour($hour = null)
    {
        // validation for constraint: string
        if (!is_null($hour) && !is_string($hour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hour, true), gettype($hour)), __LINE__);
        }
        $this->Hour = $hour;
        return $this;
    }
    /**
     * Get HourEnd value
     * @return string|null
     */
    public function getHourEnd()
    {
        return $this->HourEnd;
    }
    /**
     * Set HourEnd value
     * @param string $hourEnd
     * @return \StructType\JP_SearchSegmentTransfersByHotel
     */
    public function setHourEnd($hourEnd = null)
    {
        // validation for constraint: string
        if (!is_null($hourEnd) && !is_string($hourEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hourEnd, true), gettype($hourEnd)), __LINE__);
        }
        $this->HourEnd = $hourEnd;
        return $this;
    }
    /**
     * Get Type value
     * @return int|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param int $type
     * @return \StructType\JP_SearchSegmentTransfersByHotel
     */
    public function setType($type = null)
    {
        // validation for constraint: int
        if (!is_null($type) && !(is_int($type) || ctype_digit($type))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Route value
     * @return string|null
     */
    public function getRoute()
    {
        return $this->Route;
    }
    /**
     * Set Route value
     * @uses \EnumType\JP_RouteType::valueIsValid()
     * @uses \EnumType\JP_RouteType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $route
     * @return \StructType\JP_SearchSegmentTransfersByHotel
     */
    public function setRoute($route = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_RouteType::valueIsValid($route)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JP_RouteType', is_array($route) ? implode(', ', $route) : var_export($route, true), implode(', ', \EnumType\JP_RouteType::getValidValues())), __LINE__);
        }
        $this->Route = $route;
        return $this;
    }
    /**
     * Get HourType value
     * @return string|null
     */
    public function getHourType()
    {
        return $this->HourType;
    }
    /**
     * Set HourType value
     * @uses \EnumType\JP_HourType::valueIsValid()
     * @uses \EnumType\JP_HourType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $hourType
     * @return \StructType\JP_SearchSegmentTransfersByHotel
     */
    public function setHourType($hourType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_HourType::valueIsValid($hourType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JP_HourType', is_array($hourType) ? implode(', ', $hourType) : var_export($hourType, true), implode(', ', \EnumType\JP_HourType::getValidValues())), __LINE__);
        }
        $this->HourType = $hourType;
        return $this;
    }
}
