<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_HotelSimpleInfo StructType
 * @subpackage Structs
 */
class JP_HotelSimpleInfo extends AbstractStructBase
{
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Zone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Zone
     */
    public $Zone;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The JPCode
     * @var string
     */
    public $JPCode;
    /**
     * The Access
     * @var bool
     */
    public $Access;
    /**
     * The SupplierCode
     * @var string
     */
    public $SupplierCode;
    /**
     * The GiataCode
     * @var string
     */
    public $GiataCode;
    /**
     * The HasSynonyms
     * @var bool
     */
    public $HasSynonyms;
    /**
     * Constructor method for JP_HotelSimpleInfo
     * @uses JP_HotelSimpleInfo::setName()
     * @uses JP_HotelSimpleInfo::setZone()
     * @uses JP_HotelSimpleInfo::setCode()
     * @uses JP_HotelSimpleInfo::setJPCode()
     * @uses JP_HotelSimpleInfo::setAccess()
     * @uses JP_HotelSimpleInfo::setSupplierCode()
     * @uses JP_HotelSimpleInfo::setGiataCode()
     * @uses JP_HotelSimpleInfo::setHasSynonyms()
     * @param string $name
     * @param \StructType\JP_Zone $zone
     * @param string $code
     * @param string $jPCode
     * @param bool $access
     * @param string $supplierCode
     * @param string $giataCode
     * @param bool $hasSynonyms
     */
    public function __construct($name = null, \StructType\JP_Zone $zone = null, $code = null, $jPCode = null, $access = null, $supplierCode = null, $giataCode = null, $hasSynonyms = null)
    {
        $this
            ->setName($name)
            ->setZone($zone)
            ->setCode($code)
            ->setJPCode($jPCode)
            ->setAccess($access)
            ->setSupplierCode($supplierCode)
            ->setGiataCode($giataCode)
            ->setHasSynonyms($hasSynonyms);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\JP_HotelSimpleInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Zone value
     * @return \StructType\JP_Zone|null
     */
    public function getZone()
    {
        return $this->Zone;
    }
    /**
     * Set Zone value
     * @param \StructType\JP_Zone $zone
     * @return \StructType\JP_HotelSimpleInfo
     */
    public function setZone(\StructType\JP_Zone $zone = null)
    {
        $this->Zone = $zone;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_HotelSimpleInfo
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get JPCode value
     * @return string|null
     */
    public function getJPCode()
    {
        return $this->JPCode;
    }
    /**
     * Set JPCode value
     * @param string $jPCode
     * @return \StructType\JP_HotelSimpleInfo
     */
    public function setJPCode($jPCode = null)
    {
        // validation for constraint: string
        if (!is_null($jPCode) && !is_string($jPCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jPCode, true), gettype($jPCode)), __LINE__);
        }
        $this->JPCode = $jPCode;
        return $this;
    }
    /**
     * Get Access value
     * @return bool|null
     */
    public function getAccess()
    {
        return $this->Access;
    }
    /**
     * Set Access value
     * @param bool $access
     * @return \StructType\JP_HotelSimpleInfo
     */
    public function setAccess($access = null)
    {
        // validation for constraint: boolean
        if (!is_null($access) && !is_bool($access)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($access, true), gettype($access)), __LINE__);
        }
        $this->Access = $access;
        return $this;
    }
    /**
     * Get SupplierCode value
     * @return string|null
     */
    public function getSupplierCode()
    {
        return $this->SupplierCode;
    }
    /**
     * Set SupplierCode value
     * @param string $supplierCode
     * @return \StructType\JP_HotelSimpleInfo
     */
    public function setSupplierCode($supplierCode = null)
    {
        // validation for constraint: string
        if (!is_null($supplierCode) && !is_string($supplierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierCode, true), gettype($supplierCode)), __LINE__);
        }
        $this->SupplierCode = $supplierCode;
        return $this;
    }
    /**
     * Get GiataCode value
     * @return string|null
     */
    public function getGiataCode()
    {
        return $this->GiataCode;
    }
    /**
     * Set GiataCode value
     * @param string $giataCode
     * @return \StructType\JP_HotelSimpleInfo
     */
    public function setGiataCode($giataCode = null)
    {
        // validation for constraint: string
        if (!is_null($giataCode) && !is_string($giataCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giataCode, true), gettype($giataCode)), __LINE__);
        }
        $this->GiataCode = $giataCode;
        return $this;
    }
    /**
     * Get HasSynonyms value
     * @return bool|null
     */
    public function getHasSynonyms()
    {
        return $this->HasSynonyms;
    }
    /**
     * Set HasSynonyms value
     * @param bool $hasSynonyms
     * @return \StructType\JP_HotelSimpleInfo
     */
    public function setHasSynonyms($hasSynonyms = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasSynonyms) && !is_bool($hasSynonyms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasSynonyms, true), gettype($hasSynonyms)), __LINE__);
        }
        $this->HasSynonyms = $hasSynonyms;
        return $this;
    }
}
