<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_CruiseShipRQ StructType
 * @subpackage Structs
 */
class JP_CruiseShipRQ extends AbstractStructBase
{
    /**
     * The Login
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Login
     */
    public $Login;
    /**
     * The CruiseShipRequest
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_CruiseShipRequest
     */
    public $CruiseShipRequest;
    /**
     * The RestrictedOptions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_RestrictedOptions
     */
    public $RestrictedOptions;
    /**
     * The Version
     * @var string
     */
    public $Version;
    /**
     * The Language
     * @var string
     */
    public $Language;
    /**
     * Constructor method for JP_CruiseShipRQ
     * @uses JP_CruiseShipRQ::setLogin()
     * @uses JP_CruiseShipRQ::setCruiseShipRequest()
     * @uses JP_CruiseShipRQ::setRestrictedOptions()
     * @uses JP_CruiseShipRQ::setVersion()
     * @uses JP_CruiseShipRQ::setLanguage()
     * @param \StructType\JP_Login $login
     * @param \StructType\JP_CruiseShipRequest $cruiseShipRequest
     * @param \StructType\JP_RestrictedOptions $restrictedOptions
     * @param string $version
     * @param string $language
     */
    public function __construct(\StructType\JP_Login $login = null, \StructType\JP_CruiseShipRequest $cruiseShipRequest = null, \StructType\JP_RestrictedOptions $restrictedOptions = null, $version = null, $language = null)
    {
        $this
            ->setLogin($login)
            ->setCruiseShipRequest($cruiseShipRequest)
            ->setRestrictedOptions($restrictedOptions)
            ->setVersion($version)
            ->setLanguage($language);
    }
    /**
     * Get Login value
     * @return \StructType\JP_Login|null
     */
    public function getLogin()
    {
        return $this->Login;
    }
    /**
     * Set Login value
     * @param \StructType\JP_Login $login
     * @return \StructType\JP_CruiseShipRQ
     */
    public function setLogin(\StructType\JP_Login $login = null)
    {
        $this->Login = $login;
        return $this;
    }
    /**
     * Get CruiseShipRequest value
     * @return \StructType\JP_CruiseShipRequest|null
     */
    public function getCruiseShipRequest()
    {
        return $this->CruiseShipRequest;
    }
    /**
     * Set CruiseShipRequest value
     * @param \StructType\JP_CruiseShipRequest $cruiseShipRequest
     * @return \StructType\JP_CruiseShipRQ
     */
    public function setCruiseShipRequest(\StructType\JP_CruiseShipRequest $cruiseShipRequest = null)
    {
        $this->CruiseShipRequest = $cruiseShipRequest;
        return $this;
    }
    /**
     * Get RestrictedOptions value
     * @return \StructType\JP_RestrictedOptions|null
     */
    public function getRestrictedOptions()
    {
        return $this->RestrictedOptions;
    }
    /**
     * Set RestrictedOptions value
     * @param \StructType\JP_RestrictedOptions $restrictedOptions
     * @return \StructType\JP_CruiseShipRQ
     */
    public function setRestrictedOptions(\StructType\JP_RestrictedOptions $restrictedOptions = null)
    {
        $this->RestrictedOptions = $restrictedOptions;
        return $this;
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \StructType\JP_CruiseShipRQ
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\JP_CruiseShipRQ
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_CruiseShipRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
