<?php

namespace EnumType;

/**
 * This class stands for JP_RouteType EnumType
 * @subpackage Enumerations
 */
class JP_RouteType
{
    /**
     * Constant for value 'In'
     * @return string 'In'
     */
    const VALUE_IN = 'In';
    /**
     * Constant for value 'Out'
     * @return string 'Out'
     */
    const VALUE_OUT = 'Out';
    /**
     * Constant for value 'InOut'
     * @return string 'InOut'
     */
    const VALUE_IN_OUT = 'InOut';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_IN
     * @uses self::VALUE_OUT
     * @uses self::VALUE_IN_OUT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_IN,
            self::VALUE_OUT,
            self::VALUE_IN_OUT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
