<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_Destination ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_Destination extends AbstractStructArrayBase
{
    /**
     * The Destination
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_Destination[]
     */
    public $Destination;
    /**
     * Constructor method for ArrayOfJP_Destination
     * @uses ArrayOfJP_Destination::setDestination()
     * @param \StructType\JP_Destination[] $destination
     */
    public function __construct(array $destination = array())
    {
        $this
            ->setDestination($destination);
    }
    /**
     * Get Destination value
     * @return \StructType\JP_Destination[]|null
     */
    public function getDestination()
    {
        return $this->Destination;
    }
    /**
     * Set Destination value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Destination[] $destination
     * @return \ArrayType\ArrayOfJP_Destination
     */
    public function setDestination(array $destination = array())
    {
        foreach ($destination as $arrayOfJP_DestinationDestinationItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_DestinationDestinationItem instanceof \StructType\JP_Destination) {
                throw new \InvalidArgumentException(sprintf('The Destination property can only contain items of \StructType\JP_Destination, "%s" given', is_object($arrayOfJP_DestinationDestinationItem) ? get_class($arrayOfJP_DestinationDestinationItem) : gettype($arrayOfJP_DestinationDestinationItem)), __LINE__);
            }
        }
        $this->Destination = $destination;
        return $this;
    }
    /**
     * Add item to Destination value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Destination $item
     * @return \ArrayType\ArrayOfJP_Destination
     */
    public function addToDestination(\StructType\JP_Destination $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_Destination) {
            throw new \InvalidArgumentException(sprintf('The Destination property can only contain items of \StructType\JP_Destination, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Destination[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_Destination|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_Destination|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_Destination|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_Destination|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_Destination|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Destination
     */
    public function getAttributeName()
    {
        return 'Destination';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_Destination
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
