<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_Pax StructType
 * @subpackage Structs
 */
class JP_Pax extends AbstractStructBase
{
    /**
     * The IdPax
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $IdPax;
    /**
     * The Document
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Document
     */
    public $Document;
    /**
     * The PhoneNumbers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_PhoneNumber
     */
    public $PhoneNumbers;
    /**
     * The BillingDataAFIP
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_BillingDataAFIP
     */
    public $BillingDataAFIP;
    /**
     * The Cards
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Card
     */
    public $Cards;
    /**
     * The ResidentDiscount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_ResidentDiscount
     */
    public $ResidentDiscount;
    /**
     * The LargeFamilyDiscount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_LargeFamilyDiscount
     */
    public $LargeFamilyDiscount;
    /**
     * The TicketNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TicketNumber;
    /**
     * The Title
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Title;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Surname
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Surname;
    /**
     * The Age
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Age;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The BornDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BornDate;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address;
    /**
     * The City
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $City;
    /**
     * The Country
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Country;
    /**
     * The PostalCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PostalCode;
    /**
     * The Nationality
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Nationality;
    /**
     * The Gender
     * @var string
     */
    public $Gender;
    /**
     * Constructor method for JP_Pax
     * @uses JP_Pax::setIdPax()
     * @uses JP_Pax::setDocument()
     * @uses JP_Pax::setPhoneNumbers()
     * @uses JP_Pax::setBillingDataAFIP()
     * @uses JP_Pax::setCards()
     * @uses JP_Pax::setResidentDiscount()
     * @uses JP_Pax::setLargeFamilyDiscount()
     * @uses JP_Pax::setTicketNumber()
     * @uses JP_Pax::setTitle()
     * @uses JP_Pax::setName()
     * @uses JP_Pax::setSurname()
     * @uses JP_Pax::setAge()
     * @uses JP_Pax::setEmail()
     * @uses JP_Pax::setBornDate()
     * @uses JP_Pax::setAddress()
     * @uses JP_Pax::setCity()
     * @uses JP_Pax::setCountry()
     * @uses JP_Pax::setPostalCode()
     * @uses JP_Pax::setNationality()
     * @uses JP_Pax::setGender()
     * @param int $idPax
     * @param \StructType\JP_Document $document
     * @param \ArrayType\ArrayOfJP_PhoneNumber $phoneNumbers
     * @param \StructType\JP_BillingDataAFIP $billingDataAFIP
     * @param \ArrayType\ArrayOfJP_Card $cards
     * @param \StructType\JP_ResidentDiscount $residentDiscount
     * @param \StructType\JP_LargeFamilyDiscount $largeFamilyDiscount
     * @param string $ticketNumber
     * @param string $title
     * @param string $name
     * @param string $surname
     * @param int $age
     * @param string $email
     * @param string $bornDate
     * @param string $address
     * @param string $city
     * @param string $country
     * @param string $postalCode
     * @param string $nationality
     * @param string $gender
     */
    public function __construct($idPax = null, \StructType\JP_Document $document = null, \ArrayType\ArrayOfJP_PhoneNumber $phoneNumbers = null, \StructType\JP_BillingDataAFIP $billingDataAFIP = null, \ArrayType\ArrayOfJP_Card $cards = null, \StructType\JP_ResidentDiscount $residentDiscount = null, \StructType\JP_LargeFamilyDiscount $largeFamilyDiscount = null, $ticketNumber = null, $title = null, $name = null, $surname = null, $age = null, $email = null, $bornDate = null, $address = null, $city = null, $country = null, $postalCode = null, $nationality = null, $gender = null)
    {
        $this
            ->setIdPax($idPax)
            ->setDocument($document)
            ->setPhoneNumbers($phoneNumbers)
            ->setBillingDataAFIP($billingDataAFIP)
            ->setCards($cards)
            ->setResidentDiscount($residentDiscount)
            ->setLargeFamilyDiscount($largeFamilyDiscount)
            ->setTicketNumber($ticketNumber)
            ->setTitle($title)
            ->setName($name)
            ->setSurname($surname)
            ->setAge($age)
            ->setEmail($email)
            ->setBornDate($bornDate)
            ->setAddress($address)
            ->setCity($city)
            ->setCountry($country)
            ->setPostalCode($postalCode)
            ->setNationality($nationality)
            ->setGender($gender);
    }
    /**
     * Get IdPax value
     * @return int
     */
    public function getIdPax()
    {
        return $this->IdPax;
    }
    /**
     * Set IdPax value
     * @param int $idPax
     * @return \StructType\JP_Pax
     */
    public function setIdPax($idPax = null)
    {
        // validation for constraint: int
        if (!is_null($idPax) && !is_numeric($idPax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($idPax)), __LINE__);
        }
        $this->IdPax = $idPax;
        return $this;
    }
    /**
     * Get Document value
     * @return \StructType\JP_Document|null
     */
    public function getDocument()
    {
        return $this->Document;
    }
    /**
     * Set Document value
     * @param \StructType\JP_Document $document
     * @return \StructType\JP_Pax
     */
    public function setDocument(\StructType\JP_Document $document = null)
    {
        $this->Document = $document;
        return $this;
    }
    /**
     * Get PhoneNumbers value
     * @return \ArrayType\ArrayOfJP_PhoneNumber|null
     */
    public function getPhoneNumbers()
    {
        return $this->PhoneNumbers;
    }
    /**
     * Set PhoneNumbers value
     * @param \ArrayType\ArrayOfJP_PhoneNumber $phoneNumbers
     * @return \StructType\JP_Pax
     */
    public function setPhoneNumbers(\ArrayType\ArrayOfJP_PhoneNumber $phoneNumbers = null)
    {
        $this->PhoneNumbers = $phoneNumbers;
        return $this;
    }
    /**
     * Get BillingDataAFIP value
     * @return \StructType\JP_BillingDataAFIP|null
     */
    public function getBillingDataAFIP()
    {
        return $this->BillingDataAFIP;
    }
    /**
     * Set BillingDataAFIP value
     * @param \StructType\JP_BillingDataAFIP $billingDataAFIP
     * @return \StructType\JP_Pax
     */
    public function setBillingDataAFIP(\StructType\JP_BillingDataAFIP $billingDataAFIP = null)
    {
        $this->BillingDataAFIP = $billingDataAFIP;
        return $this;
    }
    /**
     * Get Cards value
     * @return \ArrayType\ArrayOfJP_Card|null
     */
    public function getCards()
    {
        return $this->Cards;
    }
    /**
     * Set Cards value
     * @param \ArrayType\ArrayOfJP_Card $cards
     * @return \StructType\JP_Pax
     */
    public function setCards(\ArrayType\ArrayOfJP_Card $cards = null)
    {
        $this->Cards = $cards;
        return $this;
    }
    /**
     * Get ResidentDiscount value
     * @return \StructType\JP_ResidentDiscount|null
     */
    public function getResidentDiscount()
    {
        return $this->ResidentDiscount;
    }
    /**
     * Set ResidentDiscount value
     * @param \StructType\JP_ResidentDiscount $residentDiscount
     * @return \StructType\JP_Pax
     */
    public function setResidentDiscount(\StructType\JP_ResidentDiscount $residentDiscount = null)
    {
        $this->ResidentDiscount = $residentDiscount;
        return $this;
    }
    /**
     * Get LargeFamilyDiscount value
     * @return \StructType\JP_LargeFamilyDiscount|null
     */
    public function getLargeFamilyDiscount()
    {
        return $this->LargeFamilyDiscount;
    }
    /**
     * Set LargeFamilyDiscount value
     * @param \StructType\JP_LargeFamilyDiscount $largeFamilyDiscount
     * @return \StructType\JP_Pax
     */
    public function setLargeFamilyDiscount(\StructType\JP_LargeFamilyDiscount $largeFamilyDiscount = null)
    {
        $this->LargeFamilyDiscount = $largeFamilyDiscount;
        return $this;
    }
    /**
     * Get TicketNumber value
     * @return string|null
     */
    public function getTicketNumber()
    {
        return $this->TicketNumber;
    }
    /**
     * Set TicketNumber value
     * @param string $ticketNumber
     * @return \StructType\JP_Pax
     */
    public function setTicketNumber($ticketNumber = null)
    {
        // validation for constraint: string
        if (!is_null($ticketNumber) && !is_string($ticketNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ticketNumber)), __LINE__);
        }
        $this->TicketNumber = $ticketNumber;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \StructType\JP_Pax
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\JP_Pax
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Surname value
     * @return string|null
     */
    public function getSurname()
    {
        return $this->Surname;
    }
    /**
     * Set Surname value
     * @param string $surname
     * @return \StructType\JP_Pax
     */
    public function setSurname($surname = null)
    {
        // validation for constraint: string
        if (!is_null($surname) && !is_string($surname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($surname)), __LINE__);
        }
        $this->Surname = $surname;
        return $this;
    }
    /**
     * Get Age value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAge()
    {
        return isset($this->Age) ? $this->Age : null;
    }
    /**
     * Set Age value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $age
     * @return \StructType\JP_Pax
     */
    public function setAge($age = null)
    {
        // validation for constraint: int
        if (!is_null($age) && !is_numeric($age)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($age)), __LINE__);
        }
        if (is_null($age) || (is_array($age) && empty($age))) {
            unset($this->Age);
        } else {
            $this->Age = $age;
        }
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\JP_Pax
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get BornDate value
     * @return string|null
     */
    public function getBornDate()
    {
        return $this->BornDate;
    }
    /**
     * Set BornDate value
     * @param string $bornDate
     * @return \StructType\JP_Pax
     */
    public function setBornDate($bornDate = null)
    {
        // validation for constraint: string
        if (!is_null($bornDate) && !is_string($bornDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bornDate)), __LINE__);
        }
        $this->BornDate = $bornDate;
        return $this;
    }
    /**
     * Get Address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \StructType\JP_Pax
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \StructType\JP_Pax
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \StructType\JP_Pax
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country)), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Get PostalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->PostalCode;
    }
    /**
     * Set PostalCode value
     * @param string $postalCode
     * @return \StructType\JP_Pax
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postalCode)), __LINE__);
        }
        $this->PostalCode = $postalCode;
        return $this;
    }
    /**
     * Get Nationality value
     * @return string|null
     */
    public function getNationality()
    {
        return $this->Nationality;
    }
    /**
     * Set Nationality value
     * @param string $nationality
     * @return \StructType\JP_Pax
     */
    public function setNationality($nationality = null)
    {
        // validation for constraint: string
        if (!is_null($nationality) && !is_string($nationality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nationality)), __LINE__);
        }
        $this->Nationality = $nationality;
        return $this;
    }
    /**
     * Get Gender value
     * @return string|null
     */
    public function getGender()
    {
        return $this->Gender;
    }
    /**
     * Set Gender value
     * @param string $gender
     * @return \StructType\JP_Pax
     */
    public function setGender($gender = null)
    {
        // validation for constraint: string
        if (!is_null($gender) && !is_string($gender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gender)), __LINE__);
        }
        $this->Gender = $gender;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_Pax
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
