<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_TransferOption ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_TransferOption extends AbstractStructArrayBase
{
    /**
     * The TransferOption
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_TransferOption[]
     */
    public $TransferOption;
    /**
     * Constructor method for ArrayOfJP_TransferOption
     * @uses ArrayOfJP_TransferOption::setTransferOption()
     * @param \StructType\JP_TransferOption[] $transferOption
     */
    public function __construct(array $transferOption = array())
    {
        $this
            ->setTransferOption($transferOption);
    }
    /**
     * Get TransferOption value
     * @return \StructType\JP_TransferOption[]|null
     */
    public function getTransferOption()
    {
        return $this->TransferOption;
    }
    /**
     * Set TransferOption value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_TransferOption[] $transferOption
     * @return \ArrayType\ArrayOfJP_TransferOption
     */
    public function setTransferOption(array $transferOption = array())
    {
        foreach ($transferOption as $arrayOfJP_TransferOptionTransferOptionItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_TransferOptionTransferOptionItem instanceof \StructType\JP_TransferOption) {
                throw new \InvalidArgumentException(sprintf('The TransferOption property can only contain items of \StructType\JP_TransferOption, "%s" given', is_object($arrayOfJP_TransferOptionTransferOptionItem) ? get_class($arrayOfJP_TransferOptionTransferOptionItem) : gettype($arrayOfJP_TransferOptionTransferOptionItem)), __LINE__);
            }
        }
        $this->TransferOption = $transferOption;
        return $this;
    }
    /**
     * Add item to TransferOption value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_TransferOption $item
     * @return \ArrayType\ArrayOfJP_TransferOption
     */
    public function addToTransferOption(\StructType\JP_TransferOption $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_TransferOption) {
            throw new \InvalidArgumentException(sprintf('The TransferOption property can only contain items of \StructType\JP_TransferOption, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TransferOption[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_TransferOption|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_TransferOption|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_TransferOption|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_TransferOption|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_TransferOption|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TransferOption
     */
    public function getAttributeName()
    {
        return 'TransferOption';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_TransferOption
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
