<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_Origin ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_Origin extends AbstractStructArrayBase
{
    /**
     * The Origin
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_Origin[]
     */
    public $Origin;
    /**
     * Constructor method for ArrayOfJP_Origin
     * @uses ArrayOfJP_Origin::setOrigin()
     * @param \StructType\JP_Origin[] $origin
     */
    public function __construct(array $origin = array())
    {
        $this
            ->setOrigin($origin);
    }
    /**
     * Get Origin value
     * @return \StructType\JP_Origin[]|null
     */
    public function getOrigin()
    {
        return $this->Origin;
    }
    /**
     * Set Origin value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Origin[] $origin
     * @return \ArrayType\ArrayOfJP_Origin
     */
    public function setOrigin(array $origin = array())
    {
        foreach ($origin as $arrayOfJP_OriginOriginItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_OriginOriginItem instanceof \StructType\JP_Origin) {
                throw new \InvalidArgumentException(sprintf('The Origin property can only contain items of \StructType\JP_Origin, "%s" given', is_object($arrayOfJP_OriginOriginItem) ? get_class($arrayOfJP_OriginOriginItem) : gettype($arrayOfJP_OriginOriginItem)), __LINE__);
            }
        }
        $this->Origin = $origin;
        return $this;
    }
    /**
     * Add item to Origin value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Origin $item
     * @return \ArrayType\ArrayOfJP_Origin
     */
    public function addToOrigin(\StructType\JP_Origin $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_Origin) {
            throw new \InvalidArgumentException(sprintf('The Origin property can only contain items of \StructType\JP_Origin, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Origin[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_Origin|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_Origin|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_Origin|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_Origin|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_Origin|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Origin
     */
    public function getAttributeName()
    {
        return 'Origin';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_Origin
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
