<?php

namespace EnumType;

/**
 * This class stands for JPSOAP_PriceTypes EnumType
 * @subpackage Enumerations
 */
class JPSOAP_PriceTypes
{
    /**
     * Constant for value 'Specified'
     * @return string 'Specified'
     */
    const VALUE_SPECIFIED = 'Specified';
    /**
     * Constant for value 'Porcentual'
     * @return string 'Porcentual'
     */
    const VALUE_PORCENTUAL = 'Porcentual';
    /**
     * Constant for value 'Replace'
     * @return string 'Replace'
     */
    const VALUE_REPLACE = 'Replace';
    /**
     * Constant for value 'RateDiscount'
     * @return string 'RateDiscount'
     */
    const VALUE_RATE_DISCOUNT = 'RateDiscount';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SPECIFIED
     * @uses self::VALUE_PORCENTUAL
     * @uses self::VALUE_REPLACE
     * @uses self::VALUE_RATE_DISCOUNT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SPECIFIED,
            self::VALUE_PORCENTUAL,
            self::VALUE_REPLACE,
            self::VALUE_RATE_DISCOUNT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
