<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_Price StructType
 * @subpackage Structs
 */
class JP_Price extends AbstractStructBase
{
    /**
     * The TotalFixAmounts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_TotalFixAmounts
     */
    public $TotalFixAmounts;
    /**
     * The Cancellation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Cancellation
     */
    public $Cancellation;
    /**
     * The Breakdown
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_BreakdownPrice
     */
    public $Breakdown;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * The Currency
     * @var string
     */
    public $Currency;
    /**
     * Constructor method for JP_Price
     * @uses JP_Price::setTotalFixAmounts()
     * @uses JP_Price::setCancellation()
     * @uses JP_Price::setBreakdown()
     * @uses JP_Price::setType()
     * @uses JP_Price::setCurrency()
     * @param \StructType\JP_TotalFixAmounts $totalFixAmounts
     * @param \StructType\JP_Cancellation $cancellation
     * @param \StructType\JP_BreakdownPrice $breakdown
     * @param string $type
     * @param string $currency
     */
    public function __construct(\StructType\JP_TotalFixAmounts $totalFixAmounts = null, \StructType\JP_Cancellation $cancellation = null, \StructType\JP_BreakdownPrice $breakdown = null, $type = null, $currency = null)
    {
        $this
            ->setTotalFixAmounts($totalFixAmounts)
            ->setCancellation($cancellation)
            ->setBreakdown($breakdown)
            ->setType($type)
            ->setCurrency($currency);
    }
    /**
     * Get TotalFixAmounts value
     * @return \StructType\JP_TotalFixAmounts|null
     */
    public function getTotalFixAmounts()
    {
        return $this->TotalFixAmounts;
    }
    /**
     * Set TotalFixAmounts value
     * @param \StructType\JP_TotalFixAmounts $totalFixAmounts
     * @return \StructType\JP_Price
     */
    public function setTotalFixAmounts(\StructType\JP_TotalFixAmounts $totalFixAmounts = null)
    {
        $this->TotalFixAmounts = $totalFixAmounts;
        return $this;
    }
    /**
     * Get Cancellation value
     * @return \StructType\JP_Cancellation|null
     */
    public function getCancellation()
    {
        return $this->Cancellation;
    }
    /**
     * Set Cancellation value
     * @param \StructType\JP_Cancellation $cancellation
     * @return \StructType\JP_Price
     */
    public function setCancellation(\StructType\JP_Cancellation $cancellation = null)
    {
        $this->Cancellation = $cancellation;
        return $this;
    }
    /**
     * Get Breakdown value
     * @return \StructType\JP_BreakdownPrice|null
     */
    public function getBreakdown()
    {
        return $this->Breakdown;
    }
    /**
     * Set Breakdown value
     * @param \StructType\JP_BreakdownPrice $breakdown
     * @return \StructType\JP_Price
     */
    public function setBreakdown(\StructType\JP_BreakdownPrice $breakdown = null)
    {
        $this->Breakdown = $breakdown;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\JP_Price
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \StructType\JP_Price
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
}
