<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_ServiceInfoDate StructType
 * @subpackage Structs
 */
class JP_ServiceInfoDate extends AbstractStructBase
{
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Type;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_InfoDate[]
     */
    public $Date;
    /**
     * Constructor method for JP_ServiceInfoDate
     * @uses JP_ServiceInfoDate::setType()
     * @uses JP_ServiceInfoDate::setDate()
     * @param string $type
     * @param \StructType\JP_InfoDate[] $date
     */
    public function __construct($type = null, array $date = array())
    {
        $this
            ->setType($type)
            ->setDate($date);
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\JP_ServiceInfoDate
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Date value
     * @return \StructType\JP_InfoDate[]|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * This method is responsible for validating the values passed to the setDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDateForArrayConstraintsFromSetDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $jP_ServiceInfoDateDateItem) {
            // validation for constraint: itemType
            if (!$jP_ServiceInfoDateDateItem instanceof \StructType\JP_InfoDate) {
                $invalidValues[] = is_object($jP_ServiceInfoDateDateItem) ? get_class($jP_ServiceInfoDateDateItem) : sprintf('%s(%s)', gettype($jP_ServiceInfoDateDateItem), var_export($jP_ServiceInfoDateDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Date property can only contain items of type \StructType\JP_InfoDate, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Date value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_InfoDate[] $date
     * @return \StructType\JP_ServiceInfoDate
     */
    public function setDate(array $date = array())
    {
        // validation for constraint: array
        if ('' !== ($dateArrayErrorMessage = self::validateDateForArrayConstraintsFromSetDate($date))) {
            throw new \InvalidArgumentException($dateArrayErrorMessage, __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Add item to Date value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_InfoDate $item
     * @return \StructType\JP_ServiceInfoDate
     */
    public function addToDate(\StructType\JP_InfoDate $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_InfoDate) {
            throw new \InvalidArgumentException(sprintf('The Date property can only contain items of type \StructType\JP_InfoDate, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Date[] = $item;
        return $this;
    }
}
