<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_FutureRatesCurrencyExchangeRate StructType
 * @subpackage Structs
 */
class JP_FutureRatesCurrencyExchangeRate extends AbstractStructBase
{
    /**
     * The Factor
     * Meta information extracted from the WSDL
     * - use: required
     * @var float
     */
    public $Factor;
    /**
     * The From
     * @var string
     */
    public $From;
    /**
     * The To
     * @var string
     */
    public $To;
    /**
     * Constructor method for JP_FutureRatesCurrencyExchangeRate
     * @uses JP_FutureRatesCurrencyExchangeRate::setFactor()
     * @uses JP_FutureRatesCurrencyExchangeRate::setFrom()
     * @uses JP_FutureRatesCurrencyExchangeRate::setTo()
     * @param float $factor
     * @param string $from
     * @param string $to
     */
    public function __construct($factor = null, $from = null, $to = null)
    {
        $this
            ->setFactor($factor)
            ->setFrom($from)
            ->setTo($to);
    }
    /**
     * Get Factor value
     * @return float
     */
    public function getFactor()
    {
        return $this->Factor;
    }
    /**
     * Set Factor value
     * @param float $factor
     * @return \StructType\JP_FutureRatesCurrencyExchangeRate
     */
    public function setFactor($factor = null)
    {
        // validation for constraint: float
        if (!is_null($factor) && !(is_float($factor) || is_numeric($factor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($factor, true), gettype($factor)), __LINE__);
        }
        $this->Factor = $factor;
        return $this;
    }
    /**
     * Get From value
     * @return string|null
     */
    public function getFrom()
    {
        return $this->From;
    }
    /**
     * Set From value
     * @param string $from
     * @return \StructType\JP_FutureRatesCurrencyExchangeRate
     */
    public function setFrom($from = null)
    {
        // validation for constraint: string
        if (!is_null($from) && !is_string($from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($from, true), gettype($from)), __LINE__);
        }
        $this->From = $from;
        return $this;
    }
    /**
     * Get To value
     * @return string|null
     */
    public function getTo()
    {
        return $this->To;
    }
    /**
     * Set To value
     * @param string $to
     * @return \StructType\JP_FutureRatesCurrencyExchangeRate
     */
    public function setTo($to = null)
    {
        // validation for constraint: string
        if (!is_null($to) && !is_string($to)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($to, true), gettype($to)), __LINE__);
        }
        $this->To = $to;
        return $this;
    }
}
