<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_HotelRoomCode ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_HotelRoomCode extends AbstractStructArrayBase
{
    /**
     * The Room
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_HotelRoomCode[]
     */
    public $Room;
    /**
     * Constructor method for ArrayOfJP_HotelRoomCode
     * @uses ArrayOfJP_HotelRoomCode::setRoom()
     * @param \StructType\JP_HotelRoomCode[] $room
     */
    public function __construct(array $room = array())
    {
        $this
            ->setRoom($room);
    }
    /**
     * Get Room value
     * @return \StructType\JP_HotelRoomCode[]|null
     */
    public function getRoom()
    {
        return $this->Room;
    }
    /**
     * This method is responsible for validating the values passed to the setRoom method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRoom method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRoomForArrayConstraintsFromSetRoom(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfJP_HotelRoomCodeRoomItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_HotelRoomCodeRoomItem instanceof \StructType\JP_HotelRoomCode) {
                $invalidValues[] = is_object($arrayOfJP_HotelRoomCodeRoomItem) ? get_class($arrayOfJP_HotelRoomCodeRoomItem) : sprintf('%s(%s)', gettype($arrayOfJP_HotelRoomCodeRoomItem), var_export($arrayOfJP_HotelRoomCodeRoomItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Room property can only contain items of type \StructType\JP_HotelRoomCode, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Room value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_HotelRoomCode[] $room
     * @return \ArrayType\ArrayOfJP_HotelRoomCode
     */
    public function setRoom(array $room = array())
    {
        // validation for constraint: array
        if ('' !== ($roomArrayErrorMessage = self::validateRoomForArrayConstraintsFromSetRoom($room))) {
            throw new \InvalidArgumentException($roomArrayErrorMessage, __LINE__);
        }
        $this->Room = $room;
        return $this;
    }
    /**
     * Add item to Room value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_HotelRoomCode $item
     * @return \ArrayType\ArrayOfJP_HotelRoomCode
     */
    public function addToRoom(\StructType\JP_HotelRoomCode $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_HotelRoomCode) {
            throw new \InvalidArgumentException(sprintf('The Room property can only contain items of type \StructType\JP_HotelRoomCode, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Room[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_HotelRoomCode|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_HotelRoomCode|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_HotelRoomCode|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_HotelRoomCode|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_HotelRoomCode|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Room
     */
    public function getAttributeName()
    {
        return 'Room';
    }
}
