<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_TransferOption StructType
 * @subpackage Structs
 */
class JP_TransferOption extends AbstractStructBase
{
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The OccupancyAllowed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Ocuppancy
     */
    public $OccupancyAllowed;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Images
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString1
     */
    public $Images;
    /**
     * The OriginName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OriginName;
    /**
     * The DestinationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DestinationName;
    /**
     * The Dates
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_ServiceDate
     */
    public $Dates;
    /**
     * The Languages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Language
     */
    public $Languages;
    /**
     * The TransferBookingInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_TransferBookingInfo
     */
    public $TransferBookingInfo;
    /**
     * The Origins
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Origin
     */
    public $Origins;
    /**
     * The Destinations
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Destination
     */
    public $Destinations;
    /**
     * The Luggage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Luggage
     */
    public $Luggage;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The Start
     * @var string
     */
    public $Start;
    /**
     * The End
     * @var string
     */
    public $End;
    /**
     * The Origin
     * @var int
     */
    public $Origin;
    /**
     * The OriginType
     * @var string
     */
    public $OriginType;
    /**
     * The Destination
     * @var int
     */
    public $Destination;
    /**
     * The DestinationType
     * @var string
     */
    public $DestinationType;
    /**
     * The Duration
     * @var string
     */
    public $Duration;
    /**
     * The Route
     * @var string
     */
    public $Route;
    /**
     * The StartTime
     * @var string
     */
    public $StartTime;
    /**
     * The FlightMargin
     * @var string
     */
    public $FlightMargin;
    /**
     * The Order
     * @var int
     */
    public $Order;
    /**
     * Constructor method for JP_TransferOption
     * @uses JP_TransferOption::setName()
     * @uses JP_TransferOption::setOccupancyAllowed()
     * @uses JP_TransferOption::setDescription()
     * @uses JP_TransferOption::setImages()
     * @uses JP_TransferOption::setOriginName()
     * @uses JP_TransferOption::setDestinationName()
     * @uses JP_TransferOption::setDates()
     * @uses JP_TransferOption::setLanguages()
     * @uses JP_TransferOption::setTransferBookingInfo()
     * @uses JP_TransferOption::setOrigins()
     * @uses JP_TransferOption::setDestinations()
     * @uses JP_TransferOption::setLuggage()
     * @uses JP_TransferOption::setCode()
     * @uses JP_TransferOption::setStart()
     * @uses JP_TransferOption::setEnd()
     * @uses JP_TransferOption::setOrigin()
     * @uses JP_TransferOption::setOriginType()
     * @uses JP_TransferOption::setDestination()
     * @uses JP_TransferOption::setDestinationType()
     * @uses JP_TransferOption::setDuration()
     * @uses JP_TransferOption::setRoute()
     * @uses JP_TransferOption::setStartTime()
     * @uses JP_TransferOption::setFlightMargin()
     * @uses JP_TransferOption::setOrder()
     * @param string $name
     * @param \StructType\JP_Ocuppancy $occupancyAllowed
     * @param string $description
     * @param \ArrayType\ArrayOfString1 $images
     * @param string $originName
     * @param string $destinationName
     * @param \ArrayType\ArrayOfJP_ServiceDate $dates
     * @param \ArrayType\ArrayOfJP_Language $languages
     * @param \StructType\JP_TransferBookingInfo $transferBookingInfo
     * @param \ArrayType\ArrayOfJP_Origin $origins
     * @param \ArrayType\ArrayOfJP_Destination $destinations
     * @param \StructType\JP_Luggage $luggage
     * @param string $code
     * @param string $start
     * @param string $end
     * @param int $origin
     * @param string $originType
     * @param int $destination
     * @param string $destinationType
     * @param string $duration
     * @param string $route
     * @param string $startTime
     * @param string $flightMargin
     * @param int $order
     */
    public function __construct($name = null, \StructType\JP_Ocuppancy $occupancyAllowed = null, $description = null, \ArrayType\ArrayOfString1 $images = null, $originName = null, $destinationName = null, \ArrayType\ArrayOfJP_ServiceDate $dates = null, \ArrayType\ArrayOfJP_Language $languages = null, \StructType\JP_TransferBookingInfo $transferBookingInfo = null, \ArrayType\ArrayOfJP_Origin $origins = null, \ArrayType\ArrayOfJP_Destination $destinations = null, \StructType\JP_Luggage $luggage = null, $code = null, $start = null, $end = null, $origin = null, $originType = null, $destination = null, $destinationType = null, $duration = null, $route = null, $startTime = null, $flightMargin = null, $order = null)
    {
        $this
            ->setName($name)
            ->setOccupancyAllowed($occupancyAllowed)
            ->setDescription($description)
            ->setImages($images)
            ->setOriginName($originName)
            ->setDestinationName($destinationName)
            ->setDates($dates)
            ->setLanguages($languages)
            ->setTransferBookingInfo($transferBookingInfo)
            ->setOrigins($origins)
            ->setDestinations($destinations)
            ->setLuggage($luggage)
            ->setCode($code)
            ->setStart($start)
            ->setEnd($end)
            ->setOrigin($origin)
            ->setOriginType($originType)
            ->setDestination($destination)
            ->setDestinationType($destinationType)
            ->setDuration($duration)
            ->setRoute($route)
            ->setStartTime($startTime)
            ->setFlightMargin($flightMargin)
            ->setOrder($order);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\JP_TransferOption
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get OccupancyAllowed value
     * @return \StructType\JP_Ocuppancy|null
     */
    public function getOccupancyAllowed()
    {
        return $this->OccupancyAllowed;
    }
    /**
     * Set OccupancyAllowed value
     * @param \StructType\JP_Ocuppancy $occupancyAllowed
     * @return \StructType\JP_TransferOption
     */
    public function setOccupancyAllowed(\StructType\JP_Ocuppancy $occupancyAllowed = null)
    {
        $this->OccupancyAllowed = $occupancyAllowed;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\JP_TransferOption
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Images value
     * @return \ArrayType\ArrayOfString1|null
     */
    public function getImages()
    {
        return $this->Images;
    }
    /**
     * Set Images value
     * @param \ArrayType\ArrayOfString1 $images
     * @return \StructType\JP_TransferOption
     */
    public function setImages(\ArrayType\ArrayOfString1 $images = null)
    {
        $this->Images = $images;
        return $this;
    }
    /**
     * Get OriginName value
     * @return string|null
     */
    public function getOriginName()
    {
        return $this->OriginName;
    }
    /**
     * Set OriginName value
     * @param string $originName
     * @return \StructType\JP_TransferOption
     */
    public function setOriginName($originName = null)
    {
        // validation for constraint: string
        if (!is_null($originName) && !is_string($originName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originName, true), gettype($originName)), __LINE__);
        }
        $this->OriginName = $originName;
        return $this;
    }
    /**
     * Get DestinationName value
     * @return string|null
     */
    public function getDestinationName()
    {
        return $this->DestinationName;
    }
    /**
     * Set DestinationName value
     * @param string $destinationName
     * @return \StructType\JP_TransferOption
     */
    public function setDestinationName($destinationName = null)
    {
        // validation for constraint: string
        if (!is_null($destinationName) && !is_string($destinationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationName, true), gettype($destinationName)), __LINE__);
        }
        $this->DestinationName = $destinationName;
        return $this;
    }
    /**
     * Get Dates value
     * @return \ArrayType\ArrayOfJP_ServiceDate|null
     */
    public function getDates()
    {
        return $this->Dates;
    }
    /**
     * Set Dates value
     * @param \ArrayType\ArrayOfJP_ServiceDate $dates
     * @return \StructType\JP_TransferOption
     */
    public function setDates(\ArrayType\ArrayOfJP_ServiceDate $dates = null)
    {
        $this->Dates = $dates;
        return $this;
    }
    /**
     * Get Languages value
     * @return \ArrayType\ArrayOfJP_Language|null
     */
    public function getLanguages()
    {
        return $this->Languages;
    }
    /**
     * Set Languages value
     * @param \ArrayType\ArrayOfJP_Language $languages
     * @return \StructType\JP_TransferOption
     */
    public function setLanguages(\ArrayType\ArrayOfJP_Language $languages = null)
    {
        $this->Languages = $languages;
        return $this;
    }
    /**
     * Get TransferBookingInfo value
     * @return \StructType\JP_TransferBookingInfo|null
     */
    public function getTransferBookingInfo()
    {
        return $this->TransferBookingInfo;
    }
    /**
     * Set TransferBookingInfo value
     * @param \StructType\JP_TransferBookingInfo $transferBookingInfo
     * @return \StructType\JP_TransferOption
     */
    public function setTransferBookingInfo(\StructType\JP_TransferBookingInfo $transferBookingInfo = null)
    {
        $this->TransferBookingInfo = $transferBookingInfo;
        return $this;
    }
    /**
     * Get Origins value
     * @return \ArrayType\ArrayOfJP_Origin|null
     */
    public function getOrigins()
    {
        return $this->Origins;
    }
    /**
     * Set Origins value
     * @param \ArrayType\ArrayOfJP_Origin $origins
     * @return \StructType\JP_TransferOption
     */
    public function setOrigins(\ArrayType\ArrayOfJP_Origin $origins = null)
    {
        $this->Origins = $origins;
        return $this;
    }
    /**
     * Get Destinations value
     * @return \ArrayType\ArrayOfJP_Destination|null
     */
    public function getDestinations()
    {
        return $this->Destinations;
    }
    /**
     * Set Destinations value
     * @param \ArrayType\ArrayOfJP_Destination $destinations
     * @return \StructType\JP_TransferOption
     */
    public function setDestinations(\ArrayType\ArrayOfJP_Destination $destinations = null)
    {
        $this->Destinations = $destinations;
        return $this;
    }
    /**
     * Get Luggage value
     * @return \StructType\JP_Luggage|null
     */
    public function getLuggage()
    {
        return $this->Luggage;
    }
    /**
     * Set Luggage value
     * @param \StructType\JP_Luggage $luggage
     * @return \StructType\JP_TransferOption
     */
    public function setLuggage(\StructType\JP_Luggage $luggage = null)
    {
        $this->Luggage = $luggage;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_TransferOption
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\JP_TransferOption
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\JP_TransferOption
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get Origin value
     * @return int|null
     */
    public function getOrigin()
    {
        return $this->Origin;
    }
    /**
     * Set Origin value
     * @param int $origin
     * @return \StructType\JP_TransferOption
     */
    public function setOrigin($origin = null)
    {
        // validation for constraint: int
        if (!is_null($origin) && !(is_int($origin) || ctype_digit($origin))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($origin, true), gettype($origin)), __LINE__);
        }
        $this->Origin = $origin;
        return $this;
    }
    /**
     * Get OriginType value
     * @return string|null
     */
    public function getOriginType()
    {
        return $this->OriginType;
    }
    /**
     * Set OriginType value
     * @param string $originType
     * @return \StructType\JP_TransferOption
     */
    public function setOriginType($originType = null)
    {
        // validation for constraint: string
        if (!is_null($originType) && !is_string($originType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originType, true), gettype($originType)), __LINE__);
        }
        $this->OriginType = $originType;
        return $this;
    }
    /**
     * Get Destination value
     * @return int|null
     */
    public function getDestination()
    {
        return $this->Destination;
    }
    /**
     * Set Destination value
     * @param int $destination
     * @return \StructType\JP_TransferOption
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: int
        if (!is_null($destination) && !(is_int($destination) || ctype_digit($destination))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($destination, true), gettype($destination)), __LINE__);
        }
        $this->Destination = $destination;
        return $this;
    }
    /**
     * Get DestinationType value
     * @return string|null
     */
    public function getDestinationType()
    {
        return $this->DestinationType;
    }
    /**
     * Set DestinationType value
     * @param string $destinationType
     * @return \StructType\JP_TransferOption
     */
    public function setDestinationType($destinationType = null)
    {
        // validation for constraint: string
        if (!is_null($destinationType) && !is_string($destinationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationType, true), gettype($destinationType)), __LINE__);
        }
        $this->DestinationType = $destinationType;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \StructType\JP_TransferOption
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get Route value
     * @return string|null
     */
    public function getRoute()
    {
        return $this->Route;
    }
    /**
     * Set Route value
     * @uses \EnumType\JP_RouteType::valueIsValid()
     * @uses \EnumType\JP_RouteType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $route
     * @return \StructType\JP_TransferOption
     */
    public function setRoute($route = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_RouteType::valueIsValid($route)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JP_RouteType', is_array($route) ? implode(', ', $route) : var_export($route, true), implode(', ', \EnumType\JP_RouteType::getValidValues())), __LINE__);
        }
        $this->Route = $route;
        return $this;
    }
    /**
     * Get StartTime value
     * @return string|null
     */
    public function getStartTime()
    {
        return $this->StartTime;
    }
    /**
     * Set StartTime value
     * @param string $startTime
     * @return \StructType\JP_TransferOption
     */
    public function setStartTime($startTime = null)
    {
        // validation for constraint: string
        if (!is_null($startTime) && !is_string($startTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startTime, true), gettype($startTime)), __LINE__);
        }
        $this->StartTime = $startTime;
        return $this;
    }
    /**
     * Get FlightMargin value
     * @return string|null
     */
    public function getFlightMargin()
    {
        return $this->FlightMargin;
    }
    /**
     * Set FlightMargin value
     * @param string $flightMargin
     * @return \StructType\JP_TransferOption
     */
    public function setFlightMargin($flightMargin = null)
    {
        // validation for constraint: string
        if (!is_null($flightMargin) && !is_string($flightMargin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flightMargin, true), gettype($flightMargin)), __LINE__);
        }
        $this->FlightMargin = $flightMargin;
        return $this;
    }
    /**
     * Get Order value
     * @return int|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param int $order
     * @return \StructType\JP_TransferOption
     */
    public function setOrder($order = null)
    {
        // validation for constraint: int
        if (!is_null($order) && !(is_int($order) || ctype_digit($order))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($order, true), gettype($order)), __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
}
